/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface FlowCompleted<T>
extends Flow<T> {
    @Override
    public int count();

    @Override
    default public T random() {
        int n = RANDOM.nextInt(this.count());
        for (int i = 0; i < n; ++i) {
            this.next();
        }
        return (T)this.next();
    }

    @Override
    @NotNull
    default public List<T> toList() {
        ObjectArrayList res = new ObjectArrayList(this.count());
        while (this.hasNext()) {
            res.add(this.next());
        }
        return res;
    }

    @Override
    @NotNull
    default public <K, V> Map<K, V> toMap(AFunction<T, K> keyFactory, AFunction<T, V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap(this.count());
        while (this.hasNext()) {
            Object val = this.next();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @Override
    @NotNull
    default public T[] toArray(@NotNull Class<? super T> arrayType) {
        Object[] res = (Object[])RU.cast(Array.newInstance(arrayType, this.count()));
        int i = 0;
        while (this.hasNext()) {
            res[i++] = this.next();
        }
        return res;
    }

    @Override
    @NotNull
    default public Object[] toArray() {
        Object[] res = new Object[this.count()];
        int i = 0;
        while (this.hasNext()) {
            res[i++] = this.next();
        }
        return res;
    }
}

