/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowCompleted;
import io.aether.utils.flow.FlowShort;
import io.aether.utils.interfaces.AFunctionL2O;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface FlowCompletedShort
extends FlowShort {
    public int count();

    @Override
    @NotNull
    default public ShortList toList() {
        ShortArrayList res = new ShortArrayList(this.count());
        while (this.hasNext()) {
            res.add(this.nextShort());
        }
        return res;
    }

    @Override
    default public Flow<Short> box() {
        final FlowCompletedShort self = this;
        return new FlowCompleted<Short>(){

            @Override
            public int count() {
                return self.count();
            }

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Short next() {
                return self.nextShort();
            }
        };
    }

    @Override
    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap(this.count());
        while (this.hasNext()) {
            short val = this.nextShort();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @Override
    default public short @NotNull [] toArray() {
        short[] res = new short[this.count()];
        int i = 0;
        while (this.hasNext()) {
            res[i++] = this.nextShort();
        }
        return res;
    }
}

