/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowCompletedLong;
import io.aether.utils.interfaces.ABiConsumerL2O;
import io.aether.utils.interfaces.AComparatorLong;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AConsumerLong;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.AFunctionL2Array;
import io.aether.utils.interfaces.AFunctionL2I;
import io.aether.utils.interfaces.AFunctionL2IterableLong;
import io.aether.utils.interfaces.AFunctionL2L;
import io.aether.utils.interfaces.AFunctionL2O;
import io.aether.utils.interfaces.AFunctionL2StreamLong;
import io.aether.utils.interfaces.APredicateLong;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplierLong;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlowLong
extends LongIterator,
LongIterable {
    public static final long[] EMPTY_AR = new long[0];
    public static final FlowLong EMPTY = new FlowCompletedLong(){

        public boolean hasNext() {
            return false;
        }

        public long nextLong() {
            return 0L;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public long @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        @NotNull
        public LongList toList() {
            return new LongArrayList();
        }

        @Override
        @NotNull
        public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
            return new Object2ObjectOpenHashMap();
        }
    };

    default public Flow<Long> box() {
        final FlowLong self = this;
        return new Flow<Long>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Long next() {
                return self.nextLong();
            }
        };
    }

    @NotNull
    public static FlowLong of(@NotNull FlowLong stream) {
        return stream;
    }

    @NotNull
    public static FlowLong of(final long ... array) {
        if (array.length == 0) {
            return FlowLong.of();
        }
        return new FlowCompletedLong(){
            int pos;

            public boolean hasNext() {
                return this.pos < array.length;
            }

            public long nextLong() {
                return array[this.pos++];
            }

            @Override
            public long @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<Long> c) {
                for (long v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            @NotNull
            public LongList toList() {
                return new LongArrayList(array);
            }

            @Override
            @NotNull
            public ASupplierLong toSupplier() {
                return new ASupplierLong(){
                    int pos;

                    @Override
                    public long get2() {
                        if (this.pos == array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.pos++];
                    }
                };
            }
        };
    }

    @NotNull
    public static FlowLong of(@NotNull LongIterable iterable) {
        if (iterable instanceof LongSet) {
            return FlowLong.of((LongSet)iterable);
        }
        if (iterable instanceof LongList) {
            return FlowLong.of((LongList)iterable);
        }
        return FlowLong.of(iterable.iterator());
    }

    @NotNull
    public static FlowLong of(final @NotNull LongSet collection) {
        if (collection.isEmpty()) {
            return FlowLong.of();
        }
        final LongIterator it = collection.iterator();
        return new FlowCompletedLong(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public long nextLong() {
                return it.nextLong();
            }

            @Override
            @NotNull
            public LongSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowLong of(final @NotNull LongList collection) {
        if (collection.isEmpty()) {
            return FlowLong.of();
        }
        final LongListIterator it = collection.iterator();
        return new FlowCompletedLong(){

            @Override
            public int count() {
                return collection.size();
            }

            public boolean hasNext() {
                return it.hasNext();
            }

            public long nextLong() {
                return it.nextLong();
            }

            @Override
            @NotNull
            public LongList toList() {
                return collection;
            }
        };
    }

    @NotNull
    public static FlowLong of(final @NotNull LongIterator iterator) {
        if (!iterator.hasNext()) {
            return FlowLong.of();
        }
        return new FlowLong(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public long nextLong() {
                return iterator.nextLong();
            }
        };
    }

    public static FlowLong of() {
        return EMPTY;
    }

    public static void quickSort(long[] source, int leftBorder, int rightBorder, AComparatorLong comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        long pivot = source[(leftMarker + rightMarker) / 2];
        while (true) {
            if (comparator.compare(source[leftMarker], pivot) < 0) {
                ++leftMarker;
                continue;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                --rightMarker;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    long tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                ++leftMarker;
                --rightMarker;
            }
            if (leftMarker > rightMarker) break;
        }
        if (leftMarker < rightBorder) {
            FlowLong.quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            FlowLong.quickSort(source, leftBorder, rightMarker, comparator);
        }
    }

    @NotNull
    default public LongIterator iterator() {
        return this;
    }

    default public boolean anyMatch(APredicateLong p) {
        while (this.hasNext()) {
            if (!p.test(this.nextLong())) continue;
            return true;
        }
        return false;
    }

    default public boolean noneMatch(APredicateLong p) {
        while (this.hasNext()) {
            if (!p.test(this.nextLong())) continue;
            return false;
        }
        return true;
    }

    default public FlowLong add(final long value) {
        final FlowLong oit = this;
        return new FlowLong(){
            private boolean index;

            public boolean hasNext() {
                return !this.index || oit.hasNext();
            }

            public long nextLong() {
                if (!this.index) {
                    this.index = true;
                    return value;
                }
                return oit.nextLong();
            }
        };
    }

    default public boolean noneMatchValue(long p) {
        while (this.hasNext()) {
            if (p != this.nextLong()) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatchValue(long p) {
        while (this.hasNext()) {
            if (p != this.nextLong()) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(APredicateLong p) {
        while (this.hasNext()) {
            if (p.test(this.nextLong())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <E> Flow<E> mapToObj(final @NotNull AFunctionL2O<E> f) {
        final FlowLong self = this;
        return new Flow<E>(){

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextLong());
            }
        };
    }

    @NotNull
    default public FlowLong map(final @NotNull AFunctionL2L f) {
        final FlowLong self = this;
        return new FlowLong(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public long nextLong() {
                return f.apply(self.nextLong());
            }
        };
    }

    @NotNull
    default public FlowLong apply(final AConsumerLong c) {
        final FlowLong self = this;
        return new FlowLong(){

            public boolean hasNext() {
                return self.hasNext();
            }

            public long nextLong() {
                long v = self.nextLong();
                c.accept(v);
                return v;
            }
        };
    }

    default public FlowLong addAllEls(final long ... values) {
        final FlowLong oit = this;
        return new FlowLong(){
            private int index;

            public boolean hasNext() {
                return this.index < values.length || oit.hasNext();
            }

            public long nextLong() {
                if (this.index < values.length) {
                    return values[this.index++];
                }
                return oit.nextLong();
            }
        };
    }

    default public FlowLong addAll(FlowLong values) {
        return this.addAll((LongIterator)values);
    }

    default public FlowLong addAll(final LongIterator values) {
        if (!values.hasNext()) {
            return this;
        }
        final FlowLong oit = this;
        return new FlowLong(){

            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            public long nextLong() {
                if (values.hasNext()) {
                    return values.nextLong();
                }
                return oit.nextLong();
            }
        };
    }

    default public FlowLong addAll(LongIterable values) {
        return this.addAll(values.iterator());
    }

    @NotNull
    default public FlowLong flatMap(@NotNull AFunctionL2IterableLong f) {
        return this.flatMap((long e, AConsumerLong c) -> {
            LongIterable ii = f.apply(e);
            if (ii != null) {
                for (Long v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    @NotNull
    default public FlowLong flatMap(@NotNull AFunctionL2Array f) {
        return this.flatMap((long e, AConsumerLong c) -> {
            long[] ii = f.apply(e);
            if (ii != null) {
                for (long v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    default public void foreach(AConsumer<Long> c) {
        while (this.hasNext()) {
            c.accept(this.nextLong());
        }
    }

    @NotNull
    default public FlowLong flatMap(final @NotNull AFunctionL2StreamLong f) {
        final FlowLong self = this;
        return new FlowLong(){
            FlowLong cur;

            public boolean hasNext() {
                while (this.cur == null || !this.cur.hasNext()) {
                    if (this.cur != null) {
                        this.cur = null;
                    }
                    if (!self.hasNext()) {
                        return false;
                    }
                    this.cur = f.apply(self.nextLong());
                }
                return true;
            }

            public long nextLong() {
                return this.cur.nextLong();
            }
        };
    }

    @NotNull
    default public FlowLong flatMap(final @NotNull ABiConsumerL2O<AConsumerLong> f) {
        final FlowLong oit = this;
        final LongArrayList list = new LongArrayList();
        final AConsumerLong cc = arg_0 -> ((LongArrayList)list).add(arg_0);
        return new FlowLong(){
            int pos;

            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) {
                        return false;
                    }
                    f.accept(oit.nextLong(), cc);
                }
                return true;
            }

            public long nextLong() {
                long res = list.getLong(this.pos++);
                if (this.pos == list.size()) {
                    this.pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default public long @NotNull [] toArray() {
        long[] res = new long[10];
        int i = 0;
        while (this.hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int)((double)res.length * 1.5));
            }
            res[i++] = this.nextLong();
        }
        return Arrays.copyOf(res, i);
    }

    default public <E extends Collection<Long>> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextLong());
        }
        return (E)collection;
    }

    default public <E extends LongCollection> E toCollection(@NotNull E collection) {
        while (this.hasNext()) {
            collection.add(this.nextLong());
        }
        return collection;
    }

    @NotNull
    default public FlowLong filter(final @Nullable APredicateLong predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowLong oit = this;
        return new FlowLong(){
            long last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextLong();
                    if (!predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public long nextLong() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowLong filterNot(final @Nullable APredicateLong predicate) {
        if (predicate == null) {
            return this;
        }
        final FlowLong oit = this;
        return new FlowLong(){
            long last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    this.last = oit.nextLong();
                    if (predicate.test(this.last)) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            public long nextLong() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowLong ifEmpty(final ARunnable task) {
        if (task == null) {
            return this;
        }
        final FlowLong oit = this;
        return new FlowLong(){
            boolean first = true;

            public boolean hasNext() {
                boolean res = oit.hasNext();
                if (!res && this.first) {
                    task.run();
                }
                this.first = false;
                return res;
            }

            public long nextLong() {
                return oit.nextLong();
            }
        };
    }

    @NotNull
    default public FlowLong ifEmpty(Exception error) {
        return this.ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default public FlowLong ignoreError(final Class<? extends Exception> ee) {
        if (ee == null) {
            return this;
        }
        final FlowLong oit = this;
        return new FlowLong(){
            long last;
            boolean hasNext;

            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (oit.hasNext()) {
                    try {
                        this.last = oit.nextLong();
                        this.hasNext = true;
                        return true;
                    }
                    catch (Exception ex) {
                        if (ee.isInstance(ex)) continue;
                        RU.error(ex);
                    }
                }
                return false;
            }

            public long nextLong() {
                assert (this.hasNext);
                this.hasNext = false;
                return this.last;
            }
        };
    }

    @NotNull
    default public FlowLong sort(@NotNull AComparatorLong comparator) {
        long[] arr = this.toArray();
        FlowLong.quickSort(arr, 0, arr.length, comparator);
        return FlowLong.of(arr);
    }

    @NotNull
    default public LongIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default public LongList toList() {
        return new LongArrayList(this.toArray());
    }

    @NotNull
    default public LongSet toSet() {
        return new LongOpenHashSet(this.toArray());
    }

    default public void to(AConsumerLong consumer) {
        while (this.hasNext()) {
            consumer.accept(this.nextLong());
        }
    }

    default public <E> E streamTo(AFunction<FlowLong, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default public ASupplierLong toSupplier() {
        return () -> {
            if (this.hasNext()) {
                return this.nextLong();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap();
        while (this.hasNext()) {
            long val = this.nextLong();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        while (this.hasNext()) {
            long val = this.nextLong();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionL2I valFactory) {
        Object2IntOpenHashMap res = new Object2IntOpenHashMap();
        while (this.hasNext()) {
            long val = this.nextLong();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default public <V> Long2ObjectMap<V> toMapL2O(AFunctionL2L keyFactory, AFunctionL2O<V> valFactory) {
        Long2ObjectOpenHashMap res = new Long2ObjectOpenHashMap();
        while (this.hasNext()) {
            long val = this.nextLong();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default public String join(String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(this.nextLong());
        }
        return sb.toString();
    }

    default public FlowLong distinct() {
        return this.filter(new APredicateLong(){
            private final LongSet old = new LongOpenHashSet();

            @Override
            public boolean test2(long value) {
                return this.old.add(value);
            }
        });
    }

    default public long random() {
        long[] ar = this.toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default public String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(this.nextLong()));
        }
        return sb.toString();
    }

    default public long getFirstOr(long def) {
        if (this.hasNext()) {
            return this.nextLong();
        }
        return def;
    }

    default public long getFirst() {
        if (this.hasNext()) {
            return this.nextLong();
        }
        throw new NoSuchElementException();
    }

    default public long getFirst(APredicateLong p) {
        return this.filter(p).getFirst();
    }

    default public String join() {
        StringBuilder sb = new StringBuilder();
        while (this.hasNext()) {
            sb.append(this.nextLong());
        }
        return sb.toString();
    }

    default public String join(String delim, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean first = true;
        while (this.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(this.nextLong());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default public long min(AComparatorLong comparator) {
        long min = Long.MAX_VALUE;
        while (this.hasNext()) {
            long v = this.nextLong();
            if (comparator.compare(min, v) <= 0) continue;
            min = v;
        }
        return min;
    }

    default public long min() {
        long min = Long.MAX_VALUE;
        while (this.hasNext()) {
            long v = this.nextLong();
            if (min <= v) continue;
            min = v;
        }
        return min;
    }

    default public Long max(AComparatorLong comparator) {
        long max = Long.MIN_VALUE;
        while (this.hasNext()) {
            long v = this.nextLong();
            if (comparator.compare(max, v) >= 0) continue;
            max = v;
        }
        return max;
    }

    default public Long max() {
        long max = Long.MIN_VALUE;
        while (this.hasNext()) {
            long v = this.nextLong();
            if (max >= v) continue;
            max = v;
        }
        return max;
    }
}

