/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.futures;

import io.aether.utils.futures.AFutureBase;
import io.aether.utils.futures.AFutureBaseImpl;
import io.aether.utils.futures.AFutureImpl;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.interfaces.ASupplier;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public interface AFuture
extends AFutureBase<AFuture> {
    public void done();

    public boolean tryDone();

    public AFuture and(AFuture var1);

    public AFuture apply(ARunnable var1);

    public <T> ARFuture<T> mapRFuture(ASupplier<T> var1);

    public static AFuture of() {
        return AFutureImpl.DONED;
    }

    public static AFuture make() {
        return new AFutureImpl();
    }

    public AFuture to(@NotNull AFuture var1);

    public static AFuture canceled() {
        return AFutureImpl.CANCELED;
    }

    public static AFuture of(Throwable e) {
        return new AFutureImpl(e);
    }

    public static AFuture run(Executor executor, AConsumer<AFuture> task) {
        return AFutureImpl.run(executor, task);
    }

    public static AFuture run(Executor executor, ARunnable task) {
        return AFutureImpl.run(executor, task);
    }

    public static AFuture anyAndCancel(Collection<AFuture> ff) {
        return AFutureImpl.any(ff, AFutureBase::cancel);
    }

    public static AFuture any(Collection<AFuture> ff) {
        return AFutureImpl.any(ff, a -> {});
    }

    public static AFuture all(AFuture ... ff) {
        return AFutureImpl.all(ff);
    }

    public static AFuture all(Iterator<AFuture> ff) {
        return AFutureImpl.all(ff);
    }

    public static AFuture all(Collection<AFuture> ff) {
        return AFutureImpl.all(ff);
    }

    public static AFuture completed() {
        return AFutureImpl.DONED;
    }

    public static AFuture doThrow(Throwable e) {
        return new AFutureImpl(e);
    }

    default public CompletableFuture<?> toCompletableFuture() {
        CompletableFuture res = new CompletableFuture();
        this.to(() -> {
            Object rawResult = this.getNowRaw();
            res.complete(rawResult == AFutureBaseImpl.NULL ? null : rawResult);
        });
        this.onError(res::completeExceptionally);
        this.onCancel((Self f) -> res.completeExceptionally(new CancellationException("AFuture was canceled")));
        return res;
    }
}

