/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.futures;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.TimeoutChecker;
import io.aether.utils.futures.AFutureBase;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.ARunnable;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

abstract class AFutureBaseImpl<Self extends AFutureBase<Self>>
implements AFutureBase<Self> {
    static final Object NULL = new Object();
    static final Object CANCEL_VALUE = new Object();
    static final VarHandle OFFSET_RESULT = CTypeI.of(AFutureBaseImpl.class).getFieldVarHandle("result");
    static final VarHandle TASKS = CTypeI.of(AFutureBaseImpl.class).getFieldVarHandle("tasks");
    static final Task<?> NOP_TASK = new Task<Object>(d -> {}, null, null);
    private static final boolean DISABLE_TIMEOUT = false;
    volatile Object result;
    volatile Task<Self> tasks;

    AFutureBaseImpl() {
    }

    @Override
    public Self onCancel(ARunnable l) {
        return (Self)this.onCancel((Self f) -> l.run());
    }

    @Override
    public Self onCancel(AConsumer<Self> l) {
        this.addListener(f -> {
            if (f.isCanceled()) {
                l.accept(f);
            }
        });
        return (Self)((AFutureBase)RU.cast(this));
    }

    @Override
    public Self onError(AConsumer<Throwable> l) {
        this.addListener(f -> {
            if (f.isError()) {
                l.accept(f.getError());
            }
        });
        return (Self)this;
    }

    @Override
    public boolean isFinalStatus() {
        return this.result != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSuccessful() {
        if (this.isFinalStatus()) {
            return;
        }
        AFutureBaseImpl self = this;
        if (!this.addListener(c -> {
            AFutureBaseImpl aFutureBaseImpl = self;
            synchronized (aFutureBaseImpl) {
                self.notifyAll();
            }
        })) {
            return;
        }
        try {
            AFutureBaseImpl aFutureBaseImpl = self;
            synchronized (aFutureBaseImpl) {
                while (!this.isFinalStatus()) {
                    self.wait();
                }
            }
        }
        catch (InterruptedException e) {
            RU.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitSuccessful(long timeout) {
        if (this.isFinalStatus()) {
            return true;
        }
        AFutureBaseImpl self = this;
        if (!this.addListener(c -> {
            AFutureBaseImpl aFutureBaseImpl = self;
            synchronized (aFutureBaseImpl) {
                self.notifyAll();
            }
        })) {
            return true;
        }
        try {
            long begin = RU.time();
            AFutureBaseImpl aFutureBaseImpl = self;
            synchronized (aFutureBaseImpl) {
                while (!this.isFinalStatus()) {
                    long t2 = timeout - (RU.time() - begin);
                    if (t2 <= 0L) {
                        return false;
                    }
                    self.wait(t2);
                }
                return true;
            }
        }
        catch (InterruptedException e) {
            return (Boolean)RU.error(e);
        }
    }

    @Override
    public boolean isError() {
        return this.result instanceof Throwable;
    }

    @Override
    public Self error(Throwable e) {
        this.updateStatus(e);
        return (Self)this;
    }

    @Override
    public Throwable getError() {
        return (Throwable)this.result;
    }

    @Override
    public void setError(Throwable e) {
        this.updateStatus(e);
    }

    @Override
    public boolean updateStatus(Object result) {
        if (result == null) {
            result = NULL;
        }
        if (OFFSET_RESULT.compareAndSet(this, null, result)) {
            this.pingListeners();
            return true;
        }
        return false;
    }

    @Override
    public boolean isNotDone() {
        return !this.isDone();
    }

    @Override
    public boolean isDone() {
        return this.isFinalStatus() && !this.isError() && !this.isCanceled();
    }

    @Override
    public boolean isCanceled() {
        return this.result == CANCEL_VALUE;
    }

    @Override
    public void cancel() {
        this.updateStatus(CANCEL_VALUE);
    }

    @Override
    public Self timeoutError(int seconds, String text) {
        if (this.isFinalStatus()) {
            return (Self)this;
        }
        TimeoutChecker tc = TimeoutChecker.error(seconds, () -> {
            TimeoutException er = new TimeoutException(text);
            this.setError(er);
            return text;
        });
        this.addListener(c -> tc.done());
        return (Self)this;
    }

    @Override
    public Self timeout(int seconds, ARunnable task) {
        if (this.isFinalStatus()) {
            return (Self)this;
        }
        TimeoutChecker tc = TimeoutChecker.error(seconds, () -> {
            task.run();
            return "";
        });
        this.addListener(c -> tc.done());
        return (Self)this;
    }

    @Override
    public Self timeoutMs(long ms, ARunnable task) {
        if (this.isFinalStatus()) {
            return (Self)((AFutureBase)RU.cast(this));
        }
        TimeoutChecker tc = TimeoutChecker.errorMs(ms, () -> {
            task.run();
            return "";
        });
        this.addListener(c -> tc.done());
        return (Self)((AFutureBase)RU.cast(this));
    }

    @Override
    public Self timeoutMs(long ms, AConsumer<Self> task) {
        if (this.isFinalStatus()) {
            return (Self)((AFutureBase)RU.cast(this));
        }
        TimeoutChecker tc = TimeoutChecker.errorMs(ms, () -> {
            task.accept((AFutureBase)RU.cast(this));
            return "";
        });
        this.addListener(c -> tc.done());
        return (Self)((AFutureBase)RU.cast(this));
    }

    @Override
    public boolean addListener(AConsumer<Self> l) {
        Task<Self> old;
        assert (l != null);
        LNode logContext = null;
        do {
            if ((old = this.tasks) == NOP_TASK) {
                l.accept(this);
                return false;
            }
            if (logContext != null) continue;
            logContext = Log.createContext();
        } while (!TASKS.compareAndSet(this, old, new Task<Self>(l, old, logContext)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingListeners() {
        Task<Self> t;
        AFutureBaseImpl self = this;
        do {
            if ((t = this.tasks) != NOP_TASK) continue;
            return;
        } while (!TASKS.compareAndSet(this, t, NOP_TASK));
        while (t != null) {
            Log.push(t.logContext);
            try {
                t.task.accept(self);
            }
            catch (Exception e) {
                Log.error(e, new Object[0]);
            }
            finally {
                Log.pop(t.logContext);
            }
            t = t.next;
        }
    }

    @Override
    public Self to(Executor executor, ARunnable t) {
        if (this.isDone()) {
            executor.execute(t);
            return (Self)this;
        }
        if (this.isFinalStatus()) {
            return (Self)this;
        }
        this.addListener(s -> {
            if (s.isDone()) {
                executor.execute(t);
            }
        });
        return (Self)this;
    }

    @Override
    public Self to(ARunnable t) {
        if (this.isDone()) {
            t.run();
        } else {
            this.addListener(s -> {
                if (s.isDone()) {
                    t.run();
                }
            });
        }
        return (Self)((AFutureBase)RU.cast(this));
    }

    @Override
    public Object getNowRaw() {
        return this.result;
    }

    @Override
    public boolean tryError(@NotNull Throwable error) {
        Objects.requireNonNull(error);
        return this.updateStatus(error);
    }

    @Override
    public Self tryCancel() {
        this.updateStatus(CANCEL_VALUE);
        return (Self)((AFutureBase)RU.cast(this));
    }

    protected static final class Task<Self> {
        public final AConsumer<Self> task;
        public final LNode logContext;
        public final Task<Self> next;

        public Task(AConsumer<Self> task, Task<Self> next, LNode logContext) {
            this.task = task;
            this.next = next;
            this.logContext = logContext;
        }
    }
}

