/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.futures;

import io.aether.logger.Log;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.AFutureBase;
import io.aether.utils.futures.AFutureBaseImpl;
import io.aether.utils.futures.AFutureImpl;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.futures.ARFutureWithFlag;
import io.aether.utils.interfaces.A2Function;
import io.aether.utils.interfaces.A3Consumer;
import io.aether.utils.interfaces.A3Function;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ACallable;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.tuples.Tuple2;
import io.aether.utils.tuples.Tuple3;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class ARFutureImpl<T>
extends AFutureBaseImpl<ARFuture<T>>
implements ARFuture<T> {
    static final ARFuture<Boolean> TRUE = new ARFutureImpl<Boolean>(true);
    static final ARFuture<Boolean> FALSE = new ARFutureImpl<Boolean>(false);
    private static final AConsumer<ARFuture<?>> CANCEL = AFutureBase::cancel;
    private static final VarHandle AA = MethodHandles.arrayElementVarHandle(Object[].class);

    ARFutureImpl() {
    }

    ARFutureImpl(T value) {
        this.result = value;
        this.tasks = (AFutureBaseImpl.Task)RU.cast(NOP_TASK);
    }

    @Override
    public ARFuture<T> to(@NotNull AConsumer<T> task, int timeout, ARunnable onTimeout) {
        this.to(task);
        return (ARFuture)this.timeout(timeout, onTimeout);
    }

    @Override
    public ARFutureWithFlag<T> toWithFlag() {
        ARFutureWithFlag res = new ARFutureWithFlag();
        this.to(res);
        return res;
    }

    public String toString() {
        return "ARFuture(" + (this.isDone() ? "done:" : (this.isError() ? "error:" : (this.isCanceled() ? "canceled" : ""))) + String.valueOf(this.result) + ")";
    }

    @Override
    public <T2> ARFuture<Tuple2<T, T2>> and(ARFuture<T2> f) {
        return ARFuture.all(this, f);
    }

    @Override
    public ARFuture<T> to(AConsumer<T> onDone, AConsumer<Throwable> onError) {
        this.to(onDone);
        this.onError(onError);
        return this;
    }

    @Override
    public ARFuture<T> to(AConsumer<T> onDone) {
        assert (onDone != null);
        if (this.isDone()) {
            Object r = this.result;
            if (r == NULL) {
                r = null;
            }
            onDone.accept(r);
            return this;
        }
        this.addListener(f -> {
            if (f.isDone()) {
                Object r = this.result;
                if (r == NULL) {
                    r = null;
                }
                onDone.accept(r);
            }
        });
        return this;
    }

    @Override
    public void done(T value) {
        if (!this.updateStatus(value)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean tryDone(T value) {
        return this.updateStatus(value);
    }

    @Override
    public T get() {
        this.waitSuccessful();
        Object r = this.result;
        if (r == NULL) {
            r = null;
        }
        if (this.isError()) {
            RU.error((Throwable)r);
        } else if (this.isCanceled()) {
            throw new RuntimeException();
        }
        return (T)r;
    }

    public T get(int timeout) {
        return this.get((long)timeout);
    }

    public T getSeconds(int timout) {
        return this.get((long)timout * 1000L);
    }

    @Override
    public T get(long timout) {
        Object r;
        if (!this.waitSuccessful(timout)) {
            RU.error(RU.filterFrontAndBackStackTrace(new TimeoutException(), ARFuture.class));
        }
        if ((r = this.result) == NULL) {
            r = null;
        }
        if (this.isError()) {
            RU.error((Throwable)r);
        }
        if (this.isCanceled()) {
            throw new RuntimeException();
        }
        return (T)r;
    }

    @Override
    public T getNow() {
        return this.getNowElse(null);
    }

    @Override
    public T getNowElse(T elseValue) {
        if (this.isDone()) {
            Object r = this.result;
            if (r == NULL) {
                r = null;
            }
            return (T)r;
        }
        return elseValue;
    }

    @Override
    public <E> ARFuture<E> mapSafe(@NotNull AFunction<T, E> f) {
        ARFutureImpl res = new ARFutureImpl();
        this.addListener(c -> {
            if (c.isDone()) {
                Object r = this.get();
                ((Executor)r).execute(() -> {
                    try {
                        res.done(f.apply(r));
                    }
                    catch (Throwable e) {
                        res.error(e);
                    }
                });
            } else if (c.isError()) {
                RU.error((Throwable)c.getNowRaw());
            }
        });
        return res;
    }

    @Override
    @NotNull
    public AFuture mapToFuture(@NotNull AConsumer<T> f) {
        return this.map(v -> {
            f.accept(v);
            return null;
        }).toFuture();
    }

    @Override
    @NotNull
    public <E> ARFuture<E> mapRFuture(@NotNull AFunction<T, ARFuture<E>> f) {
        ARFutureImpl res = new ARFutureImpl();
        this.addListener(c -> {
            if (c.isDone()) {
                try {
                    Object r = c.getNowRaw();
                    if (r == NULL) {
                        r = null;
                    }
                    ((ARFuture)f.apply(RU.cast(r))).to(res);
                }
                catch (Throwable e) {
                    res.error(e);
                }
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
        });
        return res;
    }

    @Override
    @NotNull
    public <E> ARFuture<E> mapWL(@NotNull AFunction<T, E> f) {
        return this.map(Log.wrap(f));
    }

    @Override
    @NotNull
    public <E> ARFuture<E> map(@NotNull AFunction<T, E> f) {
        ARFutureImpl res = new ARFutureImpl();
        this.addListener(c -> {
            if (c.isDone()) {
                try {
                    Object r = c.getNowRaw();
                    if (r == NULL) {
                        r = null;
                    }
                    res.done(f.apply(RU.cast(r)));
                }
                catch (Throwable e) {
                    res.error(e);
                }
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
        });
        return res;
    }

    @Override
    public ARFuture<T> apply(ARunnable c) {
        return this.apply((T v) -> c.run());
    }

    @Override
    public ARFuture<T> apply(AConsumer<T> c) {
        ARFutureImpl res = new ARFutureImpl();
        this.to((T d) -> {
            c.accept(d);
            res.done(d);
        });
        return res;
    }

    public <E> ARFuture<E> decompose(Class<E> t) {
        return this.decompose();
    }

    private <E> ARFuture<E> decompose() {
        ARFutureImpl res = new ARFutureImpl();
        this.addListener(v -> {
            if (v.isDone()) {
                ARFuture f = (ARFuture)v.getNowRaw();
                res.updateStatus(((AFutureBaseImpl)((Object)f)).result);
            } else {
                res.updateStatus(v.getNowRaw());
            }
        });
        return res;
    }

    @Override
    public ARFuture<T> to(@NotNull ARFuture<T> f) {
        f.onCancel(this::cancel);
        this.addListener(c -> f.updateStatus(this.getNowRaw()));
        return this;
    }

    @Override
    public ARFuture<T> to(@NotNull AFuture f) {
        f.onCancel(this::cancel);
        this.addListener(c -> {
            if (c.isDone()) {
                f.done();
            } else if (c.isCanceled()) {
                f.cancel();
            } else if (c.isError()) {
                f.error(c.getError());
            }
        });
        return this;
    }

    @Override
    public AFuture toFuture() {
        AFutureImpl res = new AFutureImpl();
        this.to(res);
        return res;
    }

    static <T> ARFuture<T> of(T value) {
        if (value instanceof Boolean) {
            return (ARFuture)RU.cast((Boolean)value != false ? TRUE : FALSE);
        }
        return new ARFutureImpl<T>(value);
    }

    static <T> ARFuture<T> canceled() {
        ARFutureImpl<T> f = new ARFutureImpl<T>();
        f.cancel();
        return f;
    }

    static <T> ARFuture<T> ofThrow(Throwable throwable) {
        ARFutureImpl<T> res = new ARFutureImpl<T>();
        res.error(throwable);
        return res;
    }

    static <T> ARFuture<T> run2(Executor executor, ACallable<ARFuture<T>> task) {
        ARFutureImpl f = new ARFutureImpl();
        executor.execute(() -> {
            try {
                ARFuture res = (ARFuture)task.call();
                res.to(f);
            }
            catch (Throwable e) {
                f.error(e);
            }
        });
        return f;
    }

    static <T> ARFuture<T> run(Executor executor, ACallable<T> task) {
        ARFutureImpl f = new ARFutureImpl();
        executor.execute(() -> {
            try {
                Object res = task.call();
                if (!f.isCanceled()) {
                    f.done(res);
                }
            }
            catch (Throwable e) {
                f.error(e);
            }
        });
        return f;
    }

    static <T> ARFuture<T> anyAndCancel(Flow<ARFuture<T>> ff) {
        return ARFutureImpl.any(ff.toList(), AFutureBase::cancel);
    }

    static <T> ARFuture<T> any(Collection<ARFuture<T>> ff) {
        return ARFutureImpl.any(ff, a -> {});
    }

    static <T> ARFuture<T> any(Collection<ARFuture<T>> ff, AConsumer<ARFuture<T>> other) {
        if (ff.size() == 1) {
            return ff.iterator().next();
        }
        for (ARFuture<T> a : ff) {
            if (!a.isDone()) continue;
            return a;
        }
        ARFutureImpl res = new ARFutureImpl();
        for (ARFuture<T> a : ff) {
            a.addListener(c -> {
                block3: {
                    block4: {
                        if (res.isDone() || !c.isFinalStatus()) break block3;
                        if (!c.isDone() && !c.isError()) break block4;
                        if (!res.updateStatus(c.getNowRaw())) break block3;
                        for (ARFuture aa : ff) {
                            if (aa == c) continue;
                            other.accept(aa);
                        }
                        break block3;
                    }
                    if (c.isCanceled() && res.updateStatus(AFutureBaseImpl.CANCEL_VALUE)) {
                        for (ARFuture aa : ff) {
                            if (aa == c) continue;
                            other.accept(aa);
                        }
                    }
                }
            });
        }
        return res;
    }

    static <T> ARFuture<T[]> all(Class<T> elType, Flow<ARFuture<T>> ff) {
        return ARFutureImpl.all(elType, ff.toList());
    }

    @SafeVarargs
    static <T> ARFuture<T[]> all(Class<T> elType, ARFuture<T> ... ff) {
        return ARFutureImpl.all(elType, List.of(ff));
    }

    static <T> ARFuture<T[]> all(Class<T> elType, Collection<ARFuture<T>> ff) {
        ARFuture[] aa = Flow.flow(ff).toArray(ARFuture.class);
        if (aa.length == 0) {
            return ARFuture.of((Object[])RU.cast(Array.newInstance(elType, 0)));
        }
        if (aa.length == 1) {
            return aa[0].map(v -> {
                Object[] res = (Object[])RU.cast(Array.newInstance(elType, 1));
                res[0] = v;
                return res;
            });
        }
        Object[] ar = (Object[])RU.cast(Array.newInstance(elType, aa.length));
        ARFutureImpl<T[]> res = new ARFutureImpl<T[]>();
        AtomicInteger counter = new AtomicInteger(1);
        int i = 0;
        for (ARFuture e : aa) {
            int finalI = i++;
            counter.incrementAndGet();
            e.addListener(c -> {
                if (res.isFinalStatus()) {
                    return;
                }
                if (c.isDone()) {
                    AA.setVolatile(ar, finalI, c.getNow());
                } else if (c.isError()) {
                    res.error(c.getError());
                } else if (c.isCanceled()) {
                    res.cancel();
                }
                if (counter.decrementAndGet() == 0) {
                    res.done((Object[])RU.cast(ar));
                }
            });
        }
        if (counter.decrementAndGet() == 0) {
            res.done((Object[])RU.cast(ar));
        }
        res.to((T v) -> {
            for (Object e : v) {
                if (e != null) continue;
                throw new IllegalStateException();
            }
        });
        return res;
    }

    static <T> ARFuture<List<T>> all(@NotNull List<ARFuture<T>> list) {
        return (ARFuture)RU.cast(ARFutureImpl.all(Object.class, (Collection)RU.cast(list)).map(List::of));
    }

    static <T1, T2> ARFuture<Tuple2<T1, T2>> all(ARFuture<T1> f1, ARFuture<T2> f2) {
        Object[] ar = new Object[2];
        ARFutureImpl res = new ARFutureImpl();
        AtomicInteger counter = new AtomicInteger(2);
        f1.addListener(c -> {
            if (res.isFinalStatus()) {
                return;
            }
            int cc = counter.decrementAndGet();
            if (c.isDone()) {
                AA.setVolatile(ar, 0, c.getNow());
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
            if (cc == 0) {
                res.done(new Tuple2(RU.cast(ar[0]), RU.cast(ar[1])));
            }
        });
        f2.addListener(c -> {
            if (res.isFinalStatus()) {
                return;
            }
            int cc = counter.decrementAndGet();
            if (c.isDone()) {
                AA.setVolatile(ar, 1, c.getNow());
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
            if (cc == 0) {
                res.done(new Tuple2(RU.cast(ar[0]), RU.cast(ar[1])));
            }
        });
        return res;
    }

    static <T1, T2, T3> ARFuture<Tuple3<T1, T2, T3>> all(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3) {
        Object[] ar = new Object[3];
        ARFutureImpl res = new ARFutureImpl();
        AtomicInteger counter = new AtomicInteger(3);
        f1.addListener(c -> {
            if (res.isFinalStatus()) {
                return;
            }
            int cc = counter.decrementAndGet();
            if (c.isDone()) {
                AA.setVolatile(ar, 0, c.getNow());
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
            if (cc == 0) {
                res.done(new Tuple3(RU.cast(ar[0]), RU.cast(ar[1]), RU.cast(ar[2])));
            }
        });
        f2.addListener(c -> {
            if (res.isFinalStatus()) {
                return;
            }
            int cc = counter.decrementAndGet();
            if (c.isDone()) {
                AA.setVolatile(ar, 1, c.getNow());
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
            if (cc == 0) {
                res.done(new Tuple3(RU.cast(ar[0]), RU.cast(ar[1]), RU.cast(ar[2])));
            }
        });
        f3.addListener(c -> {
            if (res.isFinalStatus()) {
                return;
            }
            int cc = counter.decrementAndGet();
            if (c.isDone()) {
                AA.setVolatile(ar, 2, c.getNow());
            } else if (c.isError()) {
                res.error(c.getError());
            } else if (c.isCanceled()) {
                res.cancel();
            }
            if (cc == 0) {
                res.done(new Tuple3(RU.cast(ar[0]), RU.cast(ar[1]), RU.cast(ar[2])));
            }
        });
        return res;
    }

    static <T1, T2> ARFuture<Tuple2<T1, T2>> all(ARFuture<T1> f1, ARFuture<T2> f2, ABiConsumer<T1, T2> task) {
        return ARFutureImpl.all(f1, f2).to((T vv) -> task.accept((Object)vv.val1(), (Object)vv.val2()));
    }

    static <T1, T2, T3> ARFuture<Tuple3<T1, T2, T3>> all(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3, A3Consumer<T1, T2, T3> task) {
        return ARFutureImpl.all(f1, f2, f3).to((T vv) -> task.accept(vv.val1(), vv.val2(), vv.val3()));
    }

    static <T1, T2, R> ARFuture<R> map(ARFuture<T1> f1, ARFuture<T2> f2, A2Function<T1, T2, R> task) {
        return ARFutureImpl.all(f1, f2).map(vv -> task.apply(vv.val1(), vv.val2()));
    }

    static <T1, T2, T3, R> ARFuture<R> map(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3, A3Function<T1, T2, T3, R> task) {
        return ARFutureImpl.all(f1, f2, f3).map(vv -> task.apply(vv.val1(), vv.val2(), vv.val3()));
    }
}

