/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.ConcurrentHashMapWithDefault;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.RU;
import io.aether.utils.WeakConcurrentHashMap;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFutureWithFlag;
import io.aether.utils.rcollections.BMap;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RMap;
import io.aether.utils.rcollections.RSet;
import io.aether.utils.slots.EventConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BMapImpl<K, V>
implements BMap<K, V> {
    final Set<K> allRequests = new ConcurrentHashSet<K>();
    final EventConsumer<RMap.Update<K, V>> valueUpdate = new EventConsumer();
    final Map<Object, Sender> senders = new WeakConcurrentHashMap<Object, Sender>();
    final Map<K, ARFutureWithFlag<V>> data = new ConcurrentHashMapWithDefault<Object, ARFutureWithFlag>(k -> {
        ARFutureWithFlag future = new ARFutureWithFlag();
        future.to(v -> {
            this.removeRequest(k);
            this.valueUpdate.fire(new RMap.Update<Object, Object>(k, v, null));
        });
        this.addRequest(k);
        return future;
    });

    public BMapImpl(int initialCapacity, String name, long timeoutMs) {
    }

    private boolean removeRequest(K key) {
        boolean res = this.allRequests.remove(key);
        for (Sender s : this.senders.values()) {
            s.requests.remove(key);
        }
        return res;
    }

    void addRequest(K key) {
        this.allRequests.add(key);
        for (Sender s : this.senders.values()) {
            s.requests.add(key);
        }
    }

    @Override
    @NotNull
    public ARFutureWithFlag<V> getFuture(@NotNull K key) {
        return this.data.get(key);
    }

    @Override
    @NotNull
    public Set<K> getPendingRequests() {
        return this.allRequests;
    }

    @Override
    public void putResolved(@NotNull K key, @NotNull V value) {
        this.data.get(key).tryDone((Object)value);
    }

    @Override
    public void putError(@NotNull K key, @NotNull Throwable error) {
        ARFutureWithFlag<V> future = this.data.get(key);
        future.tryError(error);
        this.removeRequest(key);
    }

    @Override
    public EventConsumer<RMap.Update<K, V>> forValueUpdate() {
        return this.valueUpdate;
    }

    Sender getSender(Object k) {
        return this.senders.computeIfAbsent(k, kk -> new Sender());
    }

    @Override
    public K[] getRequestsFor(Class<K> elementType, Object sender) {
        return this.getSender(sender).extract(elementType);
    }

    @Override
    public boolean isRequests() {
        return !this.allRequests.isEmpty();
    }

    @Override
    public boolean isRequestsFor(@NotNull Object sender) {
        return !this.getSender((Object)sender).requests.isEmpty();
    }

    @Override
    public AFuture destroy(boolean force) {
        return AFuture.completed();
    }

    @Override
    public EventConsumer<RMap.Update<K, ARFutureWithFlag<V>>> forUpdate() {
        return new EventConsumer<RMap.Update<K, ARFutureWithFlag<V>>>();
    }

    @Override
    public EventConsumer<Map.Entry<K, ARFutureWithFlag<V>>> forRemove() {
        return new EventConsumer<Map.Entry<K, ARFutureWithFlag<V>>>();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue is not supported on future maps");
    }

    @Override
    public ARFutureWithFlag<V> get(Object key) {
        return this.getFuture(RU.cast(key));
    }

    @Override
    @Nullable
    public ARFutureWithFlag<V> put(K key, ARFutureWithFlag<V> value) {
        throw new UnsupportedOperationException("Cannot put ARFutureWithFlag directly to BMapImpl");
    }

    @Override
    public ARFutureWithFlag<V> remove(Object key) {
        this.removeRequest(RU.cast(key));
        return this.data.remove(key);
    }

    @Override
    @NotNull
    public RSet<K> keySet() {
        return RSet.of(this.data.keySet());
    }

    @Override
    @NotNull
    public RCollection<ARFutureWithFlag<V>> values() {
        return RCollection.of(this.data.values());
    }

    @Override
    @NotNull
    public RSet<Map.Entry<K, ARFutureWithFlag<V>>> entrySet() {
        return RSet.of(this.data.entrySet());
    }

    class Sender {
        final Set<K> requests = new ConcurrentHashSet();

        Sender() {
            this.requests.addAll(BMapImpl.this.allRequests);
        }

        public K[] extract(Class<K> elementType) {
            ObjectArrayList r = new ObjectArrayList(this.requests);
            this.requests.clear();
            return r.toArray((Object[])RU.cast(Array.newInstance(elementType, r.size())));
        }
    }
}

