/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.RU;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.futures.ARFutureWithFlag;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RMap;
import io.aether.utils.rcollections.RSet;
import io.aether.utils.slots.EventConsumer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RFMap<K, V>
extends RMap<K, ARFutureWithFlag<V>> {
    default public <K2> RFMap<K2, V> mapKeyFuture(final AFunction<V, K2> vToK2, AFunction<V, K> vToK) {
        final RFMap self = this;
        return new RFMap<K2, V>(){
            final EventConsumer<RMap.Update<K2, ARFutureWithFlag<V>>> forUpdate = new EventConsumer();
            final EventConsumer<Map.Entry<K2, ARFutureWithFlag<V>>> forRemove = new EventConsumer();
            final Map<K2, K> keyMapping = new ConcurrentHashMap();
            {
                self.forUpdate().add(u -> {
                    if (u.newValue != null) {
                        ((ARFutureWithFlag)u.newValue).to(v -> {
                            Object newKey = vToK2.apply(v);
                            Object oldOriginalKey = this.keyMapping.put(newKey, u.key);
                            if (oldOriginalKey != null && !oldOriginalKey.equals(u.key)) {
                                self.remove(oldOriginalKey);
                            }
                            this.put(newKey, ARFuture.of(v).toWithFlag());
                            this.forUpdate.fire(new RMap.Update(newKey, ARFuture.of(v).toWithFlag(), null));
                        });
                    } else {
                        for (Map.Entry entry : this.keyMapping.entrySet()) {
                            if (!entry.getValue().equals(u.key)) continue;
                            Object keyToRemove = entry.getKey();
                            this.keyMapping.remove(keyToRemove);
                            this.remove(keyToRemove);
                            this.forUpdate.fire(new RMap.Update(keyToRemove, null, (ARFutureWithFlag)u.oldValue));
                            break;
                        }
                    }
                });
                self.forRemove().add(e -> {
                    ARFutureWithFlag future = (ARFutureWithFlag)e.getValue();
                    if (future != null) {
                        future.to(v -> {
                            for (Map.Entry entry : this.keyMapping.entrySet()) {
                                if (!entry.getValue().equals(e.getKey())) continue;
                                final Object keyToRemove = entry.getKey();
                                this.keyMapping.remove(keyToRemove);
                                this.remove(keyToRemove);
                                this.forRemove.fire(new Map.Entry<K2, ARFutureWithFlag<V>>(){

                                    @Override
                                    public K2 getKey() {
                                        return keyToRemove;
                                    }

                                    @Override
                                    public ARFutureWithFlag<V> getValue() {
                                        return ARFuture.of(v).toWithFlag();
                                    }

                                    @Override
                                    public ARFutureWithFlag<V> setValue(ARFutureWithFlag<V> value) {
                                        throw new UnsupportedOperationException();
                                    }
                                });
                                break;
                            }
                        });
                    }
                });
                for (Map.Entry entry : self.entrySet()) {
                    ARFutureWithFlag future = (ARFutureWithFlag)entry.getValue();
                    if (future == null || !future.isDone()) continue;
                    Object value = future.get();
                    Object newKey = vToK2.apply(value);
                    this.keyMapping.put(newKey, entry.getKey());
                }
            }

            @Override
            public EventConsumer<RMap.Update<K2, ARFutureWithFlag<V>>> forUpdate() {
                return this.forUpdate;
            }

            @Override
            public EventConsumer<Map.Entry<K2, ARFutureWithFlag<V>>> forRemove() {
                return this.forRemove;
            }

            @Override
            @NotNull
            public RSet<K2> keySet() {
                return new RSet<K2>(){

                    @Override
                    public EventConsumer<K2> forAdd() {
                        return new EventConsumer();
                    }

                    @Override
                    public EventConsumer<K2> forRemove() {
                        return new EventConsumer();
                    }

                    @Override
                    public int size() {
                        return keyMapping.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return keyMapping.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        return keyMapping.containsKey(o);
                    }

                    @Override
                    @NotNull
                    public Iterator<K2> iterator() {
                        return keyMapping.keySet().iterator();
                    }

                    @Override
                    @NotNull
                    public @NotNull Object @NotNull [] toArray() {
                        return keyMapping.keySet().toArray();
                    }

                    @Override
                    @NotNull
                    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                        return keyMapping.keySet().toArray(a);
                    }

                    @Override
                    public boolean add(K2 k2) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        Object key = RU.cast(o);
                        Object originalKey = keyMapping.get(key);
                        if (originalKey != null) {
                            self.remove(originalKey);
                            return true;
                        }
                        return false;
                    }
                };
            }

            @Override
            @NotNull
            public RCollection<ARFutureWithFlag<V>> values() {
                return new RCollection<ARFutureWithFlag<V>>(){

                    @Override
                    public EventConsumer<ARFutureWithFlag<V>> forAdd() {
                        return new EventConsumer();
                    }

                    @Override
                    public EventConsumer<ARFutureWithFlag<V>> forRemove() {
                        return new EventConsumer();
                    }

                    @Override
                    public int size() {
                        return keyMapping.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return keyMapping.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        ARFuture future;
                        if (o instanceof ARFuture && (future = (ARFuture)o).isDone()) {
                            Object value = future.get();
                            for (Object key : keyMapping.keySet()) {
                                Object ourFuture = this.get(key);
                                if (ourFuture == null || !((ARFutureWithFlag)ourFuture).isDone() || !((ARFutureWithFlag)ourFuture).get().equals(value)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    @NotNull
                    public Iterator<ARFutureWithFlag<V>> iterator() {
                        return new Iterator<ARFutureWithFlag<V>>(){
                            private final Iterator<K2> keyIterator;
                            {
                                this.keyIterator = keyMapping.keySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.keyIterator.hasNext();
                            }

                            @Override
                            public ARFutureWithFlag<V> next() {
                                return this.get(this.keyIterator.next());
                            }
                        };
                    }

                    @Override
                    @NotNull
                    public @NotNull Object @NotNull [] toArray() {
                        Object[] result = new Object[keyMapping.size()];
                        int i = 0;
                        for (Object key : keyMapping.keySet()) {
                            result[i++] = this.get(key);
                        }
                        return result;
                    }

                    @Override
                    @NotNull
                    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                        return (Object[])RU.cast(this.toArray());
                    }

                    @Override
                    public boolean add(ARFutureWithFlag<V> vFuture) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        ARFuture future;
                        if (o instanceof ARFuture && (future = (ARFuture)o).isDone()) {
                            Object value = future.get();
                            for (Map.Entry entry : keyMapping.entrySet()) {
                                Object ourFuture = this.get(entry.getKey());
                                if (ourFuture == null || !((ARFutureWithFlag)ourFuture).isDone() || !((ARFutureWithFlag)ourFuture).get().equals(value)) continue;
                                self.remove(entry.getValue());
                                return true;
                            }
                        }
                        return false;
                    }
                };
            }

            @Override
            @NotNull
            public RSet<Map.Entry<K2, ARFutureWithFlag<V>>> entrySet() {
                return new RSet<Map.Entry<K2, ARFutureWithFlag<V>>>(){

                    @Override
                    public EventConsumer<Map.Entry<K2, ARFutureWithFlag<V>>> forAdd() {
                        return new EventConsumer();
                    }

                    @Override
                    public EventConsumer<Map.Entry<K2, ARFutureWithFlag<V>>> forRemove() {
                        return new EventConsumer();
                    }

                    @Override
                    public int size() {
                        return keyMapping.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return keyMapping.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        if (o instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)o;
                            Object future = this.get(entry.getKey());
                            return future != null && future.equals(entry.getValue());
                        }
                        return false;
                    }

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K2, ARFutureWithFlag<V>>> iterator() {
                        return new Iterator<Map.Entry<K2, ARFutureWithFlag<V>>>(){
                            private final Iterator<K2> keyIterator;
                            {
                                this.keyIterator = keyMapping.keySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.keyIterator.hasNext();
                            }

                            @Override
                            public Map.Entry<K2, ARFutureWithFlag<V>> next() {
                                final Object key = this.keyIterator.next();
                                return new Map.Entry<K2, ARFutureWithFlag<V>>(){

                                    @Override
                                    public K2 getKey() {
                                        return key;
                                    }

                                    @Override
                                    public ARFutureWithFlag<V> getValue() {
                                        return this.get(key);
                                    }

                                    @Override
                                    public ARFutureWithFlag<V> setValue(ARFutureWithFlag<V> value) {
                                        Object oldValue = this.get(key);
                                        this.put(key, value);
                                        return oldValue;
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    @NotNull
                    public @NotNull Object @NotNull [] toArray() {
                        Object[] result = new Object[keyMapping.size()];
                        int i = 0;
                        for (final Object key : keyMapping.keySet()) {
                            result[i++] = new Map.Entry<K2, ARFutureWithFlag<V>>(){

                                @Override
                                public K2 getKey() {
                                    return key;
                                }

                                @Override
                                public ARFutureWithFlag<V> getValue() {
                                    return this.get(key);
                                }

                                @Override
                                public ARFutureWithFlag<V> setValue(ARFutureWithFlag<V> value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                        return result;
                    }

                    @Override
                    @NotNull
                    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                        return (Object[])RU.cast(this.toArray());
                    }

                    @Override
                    public boolean add(Map.Entry<K2, ARFutureWithFlag<V>> k2ARFutureEntry) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        Map.Entry entry;
                        Object key;
                        Object originalKey;
                        if (o instanceof Map.Entry && (originalKey = keyMapping.get(key = RU.cast((entry = (Map.Entry)o).getKey()))) != null) {
                            self.remove(originalKey);
                            return true;
                        }
                        return false;
                    }
                };
            }

            @Override
            public int size() {
                return this.keyMapping.size();
            }

            @Override
            public boolean isEmpty() {
                return this.keyMapping.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return this.keyMapping.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                ARFuture future;
                if (value instanceof ARFuture && (future = (ARFuture)value).isDone()) {
                    Object futureValue = future.get();
                    for (Object mappedKey : this.keyMapping.keySet()) {
                        Object ourFuture = this.get(mappedKey);
                        if (ourFuture == null || !((ARFutureWithFlag)ourFuture).isDone() || !((ARFutureWithFlag)ourFuture).get().equals(futureValue)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public ARFutureWithFlag<V> get(Object key) {
                Object originalKey = this.keyMapping.get(key);
                return originalKey != null ? (ARFutureWithFlag)self.get(originalKey) : null;
            }

            @Override
            @Nullable
            public ARFutureWithFlag<V> put(K2 key, ARFutureWithFlag<V> value) {
                throw new UnsupportedOperationException("Cannot put directly to mapped RFMap");
            }

            @Override
            public ARFutureWithFlag<V> remove(Object key) {
                Object originalKey = this.keyMapping.get(key);
                if (originalKey != null) {
                    ARFutureWithFlag removed = (ARFutureWithFlag)self.remove(originalKey);
                    this.keyMapping.remove(key);
                    return removed;
                }
                return null;
            }

            @Override
            public void putAll(@NotNull Map<? extends K2, ? extends ARFutureWithFlag<V>> m) {
                throw new UnsupportedOperationException("Cannot putAll directly to mapped RFMap");
            }

            @Override
            public void clear() {
                for (Object originalKey : this.keyMapping.values()) {
                    self.remove(originalKey);
                }
                this.keyMapping.clear();
            }
        };
    }

    default public <V2> RFMap<K, V2> mapValFuture(final AFunction<V, V2> vToV2, final AFunction<V2, V> v2ToV) {
        final RFMap self = this;
        return new RFMap<K, V2>(){
            final EventConsumer<RMap.Update<K, ARFutureWithFlag<V2>>> forUpdate = new EventConsumer();
            final EventConsumer<Map.Entry<K, ARFutureWithFlag<V2>>> forRemove = new EventConsumer();
            {
                self.forUpdate().add(u -> {
                    ARFutureWithFlag future = (ARFutureWithFlag)u.newValue;
                    if (future != null) {
                        ARFutureWithFlag mappedFuture = future.map(vToV2).toWithFlag();
                        this.forUpdate.fire(new RMap.Update(u.key, mappedFuture, (u.oldValue != null ? ((ARFutureWithFlag)u.oldValue).map(vToV2).toWithFlag() : null)));
                    } else {
                        this.forUpdate.fire(new RMap.Update(u.key, null, (u.oldValue != null ? ((ARFutureWithFlag)u.oldValue).map(vToV2).toWithFlag() : null)));
                    }
                });
                self.forRemove().add(e -> this.forRemove.fire(new Map.Entry<K, ARFutureWithFlag<V2>>((Map.Entry)e, vToV2){
                    final /* synthetic */ Map.Entry val$e;
                    final /* synthetic */ AFunction val$vToV2;
                    {
                        this.val$e = entry;
                        this.val$vToV2 = aFunction;
                    }

                    @Override
                    public K getKey() {
                        return this.val$e.getKey();
                    }

                    @Override
                    public ARFutureWithFlag<V2> getValue() {
                        return ((ARFutureWithFlag)this.val$e.getValue()).map(this.val$vToV2).toWithFlag();
                    }

                    @Override
                    public ARFutureWithFlag<V2> setValue(ARFutureWithFlag<V2> value) {
                        throw new UnsupportedOperationException();
                    }
                }));
            }

            @Override
            public EventConsumer<RMap.Update<K, ARFutureWithFlag<V2>>> forUpdate() {
                return this.forUpdate;
            }

            @Override
            public EventConsumer<Map.Entry<K, ARFutureWithFlag<V2>>> forRemove() {
                return this.forRemove;
            }

            @Override
            @NotNull
            public RSet<K> keySet() {
                return self.keySet();
            }

            @Override
            @NotNull
            public RCollection<ARFutureWithFlag<V2>> values() {
                return new RCollection<ARFutureWithFlag<V2>>(){

                    @Override
                    public EventConsumer<ARFutureWithFlag<V2>> forAdd() {
                        return new EventConsumer();
                    }

                    @Override
                    public EventConsumer<ARFutureWithFlag<V2>> forRemove() {
                        return new EventConsumer();
                    }

                    @Override
                    public int size() {
                        return self.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return self.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        ARFuture future;
                        if (o instanceof ARFuture && (future = (ARFuture)o).isDone()) {
                            Object value = future.get();
                            for (ARFutureWithFlag originalFuture : self.values()) {
                                Object mappedValue;
                                if (!originalFuture.isDone() || !(mappedValue = vToV2.apply(originalFuture.get())).equals(value)) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    @Override
                    @NotNull
                    public Iterator<ARFutureWithFlag<V2>> iterator() {
                        return new Iterator<ARFutureWithFlag<V2>>(){
                            private final Iterator<ARFutureWithFlag<V>> originalIterator;
                            {
                                this.originalIterator = self.values().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.originalIterator.hasNext();
                            }

                            @Override
                            public ARFutureWithFlag<V2> next() {
                                return this.originalIterator.next().map(vToV2).toWithFlag();
                            }
                        };
                    }

                    @Override
                    @NotNull
                    public @NotNull Object @NotNull [] toArray() {
                        Object[] result = new Object[self.size()];
                        int i = 0;
                        for (ARFutureWithFlag future : self.values()) {
                            result[i++] = future.map(vToV2);
                        }
                        return result;
                    }

                    @Override
                    @NotNull
                    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                        return (Object[])RU.cast(this.toArray());
                    }

                    @Override
                    public boolean add(ARFutureWithFlag<V2> v2ARFuture) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        ARFuture future;
                        if (o instanceof ARFuture && (future = (ARFuture)o).isDone()) {
                            Object value = future.get();
                            for (Map.Entry entry : self.entrySet()) {
                                Object mappedValue;
                                ARFutureWithFlag originalFuture = (ARFutureWithFlag)entry.getValue();
                                if (!originalFuture.isDone() || !(mappedValue = vToV2.apply(originalFuture.get())).equals(value)) continue;
                                self.remove(entry.getKey());
                                return true;
                            }
                        }
                        return false;
                    }
                };
            }

            @Override
            @NotNull
            public RSet<Map.Entry<K, ARFutureWithFlag<V2>>> entrySet() {
                return new RSet<Map.Entry<K, ARFutureWithFlag<V2>>>(){

                    @Override
                    public EventConsumer<Map.Entry<K, ARFutureWithFlag<V2>>> forAdd() {
                        return new EventConsumer();
                    }

                    @Override
                    public EventConsumer<Map.Entry<K, ARFutureWithFlag<V2>>> forRemove() {
                        return new EventConsumer();
                    }

                    @Override
                    public int size() {
                        return self.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return self.isEmpty();
                    }

                    @Override
                    public boolean contains(Object o) {
                        if (o instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)o;
                            Object ourFuture = this.get(entry.getKey());
                            return ourFuture != null && ourFuture.equals(entry.getValue());
                        }
                        return false;
                    }

                    @Override
                    @NotNull
                    public Iterator<Map.Entry<K, ARFutureWithFlag<V2>>> iterator() {
                        return new Iterator<Map.Entry<K, ARFutureWithFlag<V2>>>(){
                            private final Iterator<Map.Entry<K, ARFutureWithFlag<V>>> originalIterator;
                            {
                                this.originalIterator = self.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.originalIterator.hasNext();
                            }

                            @Override
                            public Map.Entry<K, ARFutureWithFlag<V2>> next() {
                                final Map.Entry originalEntry = this.originalIterator.next();
                                return new Map.Entry<K, ARFutureWithFlag<V2>>(){

                                    @Override
                                    public K getKey() {
                                        return originalEntry.getKey();
                                    }

                                    @Override
                                    public ARFutureWithFlag<V2> getValue() {
                                        return ((ARFutureWithFlag)originalEntry.getValue()).map(vToV2).toWithFlag();
                                    }

                                    @Override
                                    public ARFutureWithFlag<V2> setValue(ARFutureWithFlag<V2> value) {
                                        ARFutureWithFlag oldValue = (ARFutureWithFlag)originalEntry.getValue();
                                        originalEntry.setValue(value.map(v2ToV).toWithFlag());
                                        return oldValue.map(vToV2).toWithFlag();
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    @NotNull
                    public @NotNull Object @NotNull [] toArray() {
                        Object[] result = new Object[self.size()];
                        int i = 0;
                        for (final Map.Entry entry : self.entrySet()) {
                            result[i++] = new Map.Entry<K, ARFutureWithFlag<V2>>(){

                                @Override
                                public K getKey() {
                                    return entry.getKey();
                                }

                                @Override
                                public ARFutureWithFlag<V2> getValue() {
                                    return ((ARFutureWithFlag)entry.getValue()).map(vToV2).toWithFlag();
                                }

                                @Override
                                public ARFutureWithFlag<V2> setValue(ARFutureWithFlag<V2> value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                        return result;
                    }

                    @Override
                    @NotNull
                    public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                        return (Object[])RU.cast(this.toArray());
                    }

                    @Override
                    public boolean add(Map.Entry<K, ARFutureWithFlag<V2>> kARFutureEntry) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        if (o instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)o;
                            self.remove(entry.getKey());
                            return true;
                        }
                        return false;
                    }
                };
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return self.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                ARFuture future;
                if (value instanceof ARFuture && (future = (ARFuture)value).isDone()) {
                    Object futureValue = future.get();
                    for (ARFutureWithFlag originalFuture : self.values()) {
                        Object mappedValue;
                        if (!originalFuture.isDone() || !(mappedValue = vToV2.apply(originalFuture.get())).equals(futureValue)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public ARFutureWithFlag<V2> get(Object key) {
                ARFutureWithFlag originalFuture = (ARFutureWithFlag)self.get(key);
                return originalFuture != null ? originalFuture.map(vToV2).toWithFlag() : null;
            }

            @Override
            @Nullable
            public ARFutureWithFlag<V2> put(K key, ARFutureWithFlag<V2> value) {
                ARFutureWithFlag originalFuture = (ARFutureWithFlag)self.get(key);
                ARFutureWithFlag newFuture = value.map(v2ToV).toWithFlag();
                self.put(key, newFuture);
                return originalFuture != null ? originalFuture.map(vToV2).toWithFlag() : null;
            }

            @Override
            public ARFutureWithFlag<V2> remove(Object key) {
                ARFutureWithFlag removed = (ARFutureWithFlag)self.remove(key);
                return removed != null ? removed.map(vToV2).toWithFlag() : null;
            }

            @Override
            public void putAll(@NotNull Map<? extends K, ? extends ARFutureWithFlag<V2>> m) {
                for (Map.Entry entry : m.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
            }

            @Override
            public void clear() {
                self.clear();
            }
        };
    }

    default public <K2, V2> RFMap<K2, V2> mapFuture(AFunction<K, K2> kToK2, AFunction<K2, K> k2ToK, AFunction<V, V2> vToV2, AFunction<V2, V> v2ToV) {
        return this.mapKeyFuture(v -> kToK2.apply(null), v -> null).mapValFuture(vToV2, v2ToV);
    }
}

