/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.ConcurrentHashMapWithDefault;
import io.aether.utils.RU;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.futures.ARFutureWithFlag;
import io.aether.utils.interfaces.ABiFunction;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.rcollections.RCol;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RFMap;
import io.aether.utils.rcollections.RMapBySrc;
import io.aether.utils.rcollections.RSet;
import io.aether.utils.slots.EventConsumer;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RMap<K, V>
extends Map<K, V> {
    public EventConsumer<Update<K, V>> forUpdate();

    public EventConsumer<Map.Entry<K, V>> forRemove();

    default public RFMap<K, V> mapToFutures() {
        final RMap self = this;
        final ConcurrentHashMapWithDefault<Object, ARFutureWithFlag> map2 = new ConcurrentHashMapWithDefault<Object, ARFutureWithFlag>(k -> {
            ARFutureWithFlag res = new ARFutureWithFlag();
            res.to(v -> {
                if (res.tryRequest()) {
                    self.put(k, v);
                }
            });
            return res;
        });
        return new RFMap<K, V>(){
            final EventConsumer<Update<K, ARFutureWithFlag<V>>> forUpdate = new EventConsumer();
            final EventConsumer<Map.Entry<K, ARFutureWithFlag<V>>> forRemove = new EventConsumer();
            {
                for (Map.Entry e : self.entrySet()) {
                    if (e.getValue() == null) continue;
                    ARFutureWithFlag f = new ARFutureWithFlag();
                    f.done(e.getValue());
                    f.tryRequest();
                    map2.put(e.getKey(), f);
                }
                self.forUpdate().add(u -> {
                    ARFutureWithFlag f = (ARFutureWithFlag)map2.get(u.key);
                    f.tryRequest();
                    f.tryDone(u.newValue);
                });
                self.forRemove().add(u -> {
                    ARFutureWithFlag f = (ARFutureWithFlag)map2.get(u.getKey());
                    f.cancel();
                    this.forRemove.fire(new AbstractMap.SimpleEntry(u.getKey(), f));
                });
            }

            @Override
            public EventConsumer<Update<K, ARFutureWithFlag<V>>> forUpdate() {
                return this.forUpdate;
            }

            @Override
            public EventConsumer<Map.Entry<K, ARFutureWithFlag<V>>> forRemove() {
                return this.forRemove;
            }

            @Override
            @NotNull
            public RSet<K> keySet() {
                return RSet.of(map2.keySet());
            }

            @Override
            @NotNull
            public RCollection<ARFutureWithFlag<V>> values() {
                return RCollection.of((Collection)RU.cast(map2.values()));
            }

            @Override
            @NotNull
            public RSet<Map.Entry<K, ARFutureWithFlag<V>>> entrySet() {
                return RSet.of((Set)RU.cast(map2.entrySet()));
            }

            @Override
            public int size() {
                return map2.size();
            }

            @Override
            public boolean isEmpty() {
                return map2.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return map2.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map2.containsValue(value);
            }

            @Override
            public ARFutureWithFlag<V> get(Object key) {
                return (ARFutureWithFlag)map2.get(key);
            }

            @Override
            @Nullable
            public ARFutureWithFlag<V> put(K key, ARFutureWithFlag<V> value) {
                return map2.compute(key, (k, v) -> {
                    if (v != null) {
                        value.to((ARFuture)v);
                        return v;
                    }
                    return (ARFutureWithFlag)RU.cast(value);
                });
            }

            @Override
            public ARFutureWithFlag<V> remove(Object key) {
                ARFutureWithFlag res = (ARFutureWithFlag)map2.remove(key);
                if (res != null) {
                    res.to(() -> self.remove(key));
                }
                return res;
            }
        };
    }

    default public RSet<V> mapToValues(final AFunction<V, K> keyGetter) {
        final RMap self = this;
        return new RSet<V>(){
            final EventConsumer<V> fAdd = new EventConsumer();
            final EventConsumer<V> fRemove = new EventConsumer();

            @Override
            public void toString(AString sb) {
                boolean first = true;
                for (Object e : this) {
                    if (first) {
                        first = false;
                    } else {
                        sb.add(", ");
                    }
                    sb.add(e);
                }
            }

            public String toString() {
                return this.toString2();
            }

            @Override
            public EventConsumer<V> forAdd() {
                return this.fAdd;
            }

            @Override
            public EventConsumer<V> forRemove() {
                return this.fRemove;
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return self.containsValue(RU.cast(o));
            }

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return self.values().iterator();
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return self.values().toArray();
            }

            @Override
            @NotNull
            public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                return self.values().toArray(a);
            }

            @Override
            public boolean add(V v) {
                Object old = self.put(keyGetter.apply(v), v);
                return old != v;
            }

            @Override
            public boolean remove(Object o) {
                return self.remove(keyGetter.apply(RU.cast(o)), RU.cast(o));
            }
        };
    }

    default public void link(RMap<K, V> other) {
        this.forUpdate().add(e -> other.put(e.key, e.newValue));
        this.forRemove().add(e -> other.remove(e.getKey()));
        other.forUpdate().add(e -> this.put(e.key, e.newValue));
        other.forRemove().add(e -> this.remove(e.getKey()));
        other.putAll(this);
        this.putAll(other);
    }

    default public <V2> RMap<K, V2> mapVal(AFunction<V, V2> v1ToV2, AFunction<V2, V> v2ToV1) {
        return this.map(AFunction.stub(), AFunction.stub(), v1ToV2, v2ToV1);
    }

    default public <V2> RMap<K, V2> mapVal(AFunction<V, V2> v1ToV2) {
        return this.map(AFunction.stub(), AFunction.stub(), v -> {
            if (v == null) {
                return null;
            }
            return v1ToV2.apply(v);
        }, c -> {
            throw new UnsupportedOperationException();
        });
    }

    default public <K2, V2> RMap<K2, V2> map(final AFunction<K, K2> k1ToK2, final AFunction<K2, K> k2ToK1, final AFunction<V, V2> v1ToV2, final AFunction<V2, V> v2ToV1) {
        final RMap self = this;
        return new RMap<K2, V2>(){
            final EventConsumer<Update<K2, V2>> forUpdate = new EventConsumer();
            final EventConsumer<Map.Entry<K2, V2>> forRemove = new EventConsumer();
            {
                self.forUpdate().add(u -> this.forUpdate.fire(new Update(k1ToK2.apply(u.key), v1ToV2.apply(u.newValue), v1ToV2.apply(u.oldValue))));
                self.forRemove().add(u -> this.forRemove.fire(new AbstractMap.SimpleEntry<K2, V2>(k1ToK2.apply(u.getKey()), v1ToV2.apply(u.getValue()), (Map.Entry)u, v2ToV1){
                    final /* synthetic */ Map.Entry val$u;
                    final /* synthetic */ AFunction val$v2ToV1;
                    {
                        this.val$u = entry;
                        this.val$v2ToV1 = aFunction2;
                        super(key, value);
                    }

                    @Override
                    public V2 setValue(V2 value) {
                        return v1ToV2.apply(this.val$u.setValue(this.val$v2ToV1.apply(value)));
                    }
                }));
            }

            @Override
            public EventConsumer<Update<K2, V2>> forUpdate() {
                return this.forUpdate;
            }

            @Override
            public EventConsumer<Map.Entry<K2, V2>> forRemove() {
                return this.forRemove;
            }

            @Override
            @NotNull
            public RSet<K2> keySet() {
                return self.keySet().map(k1ToK2, k2ToK1);
            }

            @Override
            @NotNull
            public RCollection<V2> values() {
                return self.values().map(v1ToV2, v -> {
                    throw new UnsupportedOperationException();
                });
            }

            @Override
            @NotNull
            public RSet<Map.Entry<K2, V2>> entrySet() {
                return self.entrySet().map(new AFunction<Map.Entry<K, V>, Map.Entry<K2, V2>>(){

                    @Override
                    public Map.Entry<K2, V2> apply2(final Map.Entry<K, V> entry) throws Throwable {
                        return new Map.Entry<K2, V2>(){

                            @Override
                            public K2 getKey() {
                                return k1ToK2.apply(entry.getKey());
                            }

                            @Override
                            public V2 getValue() {
                                return v1ToV2.apply(entry.getValue());
                            }

                            @Override
                            public V2 setValue(V2 value) {
                                Object old = entry.setValue(v2ToV1.apply(value));
                                return v1ToV2.apply(old);
                            }
                        };
                    }
                }, new AFunction<Map.Entry<K2, V2>, Map.Entry<K, V>>(){

                    @Override
                    public Map.Entry<K, V> apply2(final Map.Entry<K2, V2> e) throws Throwable {
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return k2ToK1.apply(e.getKey());
                            }

                            @Override
                            public V getValue() {
                                return v2ToV1.apply(e.getValue());
                            }

                            @Override
                            public V setValue(V value) {
                                return v2ToV1.apply(e.setValue(v1ToV2.apply(value)));
                            }
                        };
                    }
                });
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return self.containsKey(k2ToK1.apply(RU.cast(key)));
            }

            @Override
            public boolean containsValue(Object value) {
                return self.containsValue(v2ToV1.apply(RU.cast(value)));
            }

            @Override
            public V2 get(Object key) {
                return v1ToV2.apply(self.get(k2ToK1.apply(RU.cast(key))));
            }

            @Override
            @Nullable
            public V2 put(K2 key, V2 value) {
                return v1ToV2.apply(self.put(k2ToK1.apply(key), v2ToV1.apply(value)));
            }

            @Override
            public V2 remove(Object key) {
                return v1ToV2.apply(self.remove(k2ToK1.apply(RU.cast(key))));
            }
        };
    }

    default public <K2> RMap<K2, V> mapKey(ABiFunction<K, V, K2> k1ToK2) {
        RMap res = RCol.map();
        this.forRemove().add(e -> {
            Object k2 = k1ToK2.apply((Object)e.getKey(), (Object)e.getValue());
            res.remove(k2);
        });
        this.forUpdate().add(e -> {
            Object k2 = k1ToK2.apply((Object)e.key, (Object)e.newValue);
            res.put(k2, e.newValue);
        });
        return res;
    }

    @Override
    default public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    default public void clear() {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    @NotNull
    public RSet<K> keySet();

    @Override
    @NotNull
    public RCollection<V> values();

    @Override
    @NotNull
    public RSet<Map.Entry<K, V>> entrySet();

    public static <K, V> RMap<K, V> of(Map<K, V> src) {
        if (src instanceof RMap) {
            return (RMap)RU.cast(src);
        }
        return new RMapBySrc<K, V>(src);
    }

    public static class Update<K, V> {
        public final K key;
        public final V newValue;
        public final V oldValue;

        public Update(K key, V newValue, V oldValue) {
            this.key = key;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Update(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.newValue = e.getValue();
            this.oldValue = e.getValue();
        }
    }
}

