/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.rcollections.RCol;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RMap;
import io.aether.utils.rcollections.RSetBySrc;
import io.aether.utils.slots.EventConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface RSet<T>
extends RCollection<T>,
Set<T> {
    @Override
    default public boolean retainAll(@NotNull Collection<?> c) {
        return RCollection.super.retainAll(c);
    }

    default public boolean addAndRemove(Set<T> s) {
        boolean res = this.addAll((Collection<? extends T>)s);
        Iterator t = this.iterator();
        while (t.hasNext()) {
            if (s.contains(t.next())) continue;
            t.remove();
            res = true;
        }
        return res;
    }

    @Override
    default public void clear() {
        RCollection.super.clear();
    }

    @Override
    default public boolean addAll(@NotNull Collection<? extends T> c) {
        return RCollection.super.addAll(c);
    }

    @Override
    default public boolean containsAll(@NotNull Collection<?> c) {
        return RCollection.super.containsAll(c);
    }

    @Override
    default public boolean removeAll(@NotNull Collection<?> c) {
        return RCollection.super.removeAll(c);
    }

    default public <K> RMap<K, T> toMap(AFunction<T, K> keyGetter) {
        RMap res = RCol.map();
        this.forAdd().add(v -> res.put(keyGetter.apply(v), v));
        this.forRemove().add(v -> res.remove(keyGetter.apply(v)));
        res.forUpdate().add(e -> {
            if (e.newValue != null) {
                this.add(e.newValue);
            }
            if (e.oldValue != null) {
                this.remove(e.oldValue);
            }
        });
        res.forRemove().add(e -> {
            if (e.getValue() != null) {
                this.add(e.getValue());
            }
        });
        return res;
    }

    default public <T2> void link(RSet<T2> other, AFunction<T, T2> f, AFunction<T2, T> back) {
        this.forAdd().add(v -> other.add(f.apply(v)));
        this.forRemove().add(v -> other.remove(f.apply(v)));
        other.forAdd().add(v -> this.add(back.apply(v)));
        other.forRemove().add(v -> this.remove(back.apply(v)));
        for (Object e : other) {
            this.add(back.apply(e));
        }
        for (Object e : this) {
            other.add(f.apply(e));
        }
    }

    default public void link(RSet<T> other) {
        this.forAdd().add(other::add);
        this.forRemove().add(other::remove);
        other.forAdd().add(this::add);
        other.forRemove().add(this::remove);
        this.addAll((Collection<? extends T>)other);
        other.addAll(this);
    }

    @Override
    @NotNull
    default public <T2> RSet<T2> map(final AFunction<T, T2> f, final AFunction<T2, T> back) {
        final RSet self = this;
        return new RSet<T2>(){
            final EventConsumer<T2> forAdd = new EventConsumer();
            final EventConsumer<T2> forRemove = new EventConsumer();

            @Override
            public void toString(AString sb) {
                boolean first = true;
                for (Object e : this) {
                    if (first) {
                        first = false;
                    } else {
                        sb.add(", ");
                    }
                    sb.add(e);
                }
            }

            public String toString() {
                return this.toString2();
            }

            @Override
            public EventConsumer<T2> forAdd() {
                return this.forAdd;
            }

            @Override
            public EventConsumer<T2> forRemove() {
                return this.forRemove;
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return self.contains(back.apply(RU.cast(o)));
            }

            @Override
            @NotNull
            public Iterator<T2> iterator() {
                final Iterator it = self.iterator();
                return new Iterator<T2>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T2 next() {
                        return f.apply(it.next());
                    }
                };
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return Flow.flow(self).map(f).toArray();
            }

            @Override
            @NotNull
            public <T5> @NotNull T5 @NotNull [] toArray(@NotNull @NotNull T5 @NotNull [] a) {
                return Flow.flow(self).map(f).toList().toArray(a);
            }

            @Override
            public boolean add(T2 t2) {
                return self.add(back.apply(t2));
            }

            @Override
            public boolean remove(Object o) {
                return self.remove(back.apply(RU.cast(o)));
            }
        };
    }

    default public <T2> RSet<T2> map(AFunction<T, T2> f) {
        RSet res = RCol.set();
        this.forAdd().add(v -> res.add(f.apply(v)));
        this.forRemove().add(v -> res.remove(f.apply(v)));
        return res;
    }

    public static <E> RSet<E> of(Set<E> src) {
        if (src instanceof RSet) {
            return (RSet)RU.cast(src);
        }
        return new RSetBySrc<E>(src);
    }
}

