/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.slots;

import io.aether.utils.CTypeI;
import io.aether.utils.TaskRun;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.ARunnable;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.lang.invoke.VarHandle;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public class EventSourceRunnable {
    private static final VarHandle OFFSET_ENABLED = CTypeI.of(EventSourceRunnable.class).getFieldVarHandle("enabled");
    private static final Executor DEF = Runnable::run;
    private final Queue<TaskRun> tasks = new ConcurrentLinkedQueue<TaskRun>();
    private final Set<Runnable> tasksPermanent = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet());
    private volatile boolean enabled;

    public AFuture toFuture() {
        if (this.isEnabled()) {
            return AFuture.completed();
        }
        AFuture f = AFuture.make();
        this.run(f::done);
        return f;
    }

    public void enabled(boolean f) {
        if (f) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public boolean enable() {
        if (!OFFSET_ENABLED.compareAndSet(this, false, true)) {
            return false;
        }
        for (Runnable task : this.tasksPermanent) {
            if (!this.enabled) break;
            task.run();
        }
        this.runTasks();
        return true;
    }

    public void disable() {
        this.enabled = false;
    }

    private void runTasks() {
        TaskRun task;
        if (!this.enabled) {
            return;
        }
        while ((task = this.tasks.poll()) != null) {
            task.run();
        }
    }

    public void run(final Executor executor, final ARunnable task) {
        if (this.isEnabled()) {
            executor.execute(task);
        } else {
            TaskRun t = new TaskRun(){

                public String toString() {
                    return task.toString();
                }

                @Override
                protected void runTask() {
                    executor.execute(task);
                }
            };
            this.tasks.add(t);
            this.runTasks();
        }
    }

    public void run(ARunnable task) {
        if (this.isEnabled()) {
            task.run();
        } else {
            this.run(DEF, task);
        }
    }

    public void runPermanent(ARunnable task) {
        this.tasksPermanent.add(task);
        if (this.enabled) {
            task.run();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.enabled = false;
        this.tasks.clear();
        this.tasksPermanent.clear();
    }
}

