package io.aether.logger;

import io.aether.utils.CTypeI;
import io.aether.utils.interfaces.A3Predicate;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.APredicate;

import java.lang.invoke.VarHandle;
import java.util.Set;
import java.util.regex.Pattern;

public class LogFilter {
    private static final VarHandle DROP_UPDATER = CTypeI.of(LogFilter.class).getFieldVarHandle("dropFields");
    private static final VarHandle PRED_UPDATER = CTypeI.of(LogFilter.class).getFieldVarHandle("predicate");
    volatile A3Predicate<LNode, String, Object> dropFields = A3Predicate.FALSE_STUB();
    volatile APredicate<LNode> predicate = APredicate.TRUE_STUB();

    public LNode dropFields(LNode node) {
        if (dropFields == A3Predicate.TRUE_STUB()) return node;
        return new LNode() {
            @Override
            public int count() {
                return 7;
            }

            @Override
            protected Object get(String key, Set<LNode> old) {
                if (old.add(node)) {
                    var v = node.get(key);
                    if (dropFields.test2(node, key, v)) return null;
                    return v;
                }
                return null;
            }

            @Override
            public void foreach(Set<String> exclude, ABiConsumer<String, Object> c) {
                node.foreach(exclude, (String k, Object v) -> {
                    if (dropFields.test(node, k, v)) return;
                    c.accept(k, v);
                });
            }
        };
    }

    public void drop(A3Predicate<LNode, String, Object> p) {
        while (true) {
            var o = dropFields;
            if (DROP_UPDATER.compareAndSet(this, o, new A3Predicate<LNode, String, Object>() {
                @Override
                public boolean test2(LNode value1, String value2, Object value3) {
                    try {
                        if (o.test(value1, value2, value3)) {
                            return true;
                        }
                    } catch (Exception e) {
                        Log.error(e);
                    }
                    try {
                        if (p.test(value1, value2, value3)) {
                            return true;
                        }
                    } catch (Exception e) {
                        Log.error(e);
                    }
                    return false;
                }
            })) return;
        }
    }

    public void not(String text) {
        not((n) -> n.toString().contains(text));
    }

    public void filter(String text) {
        filter((n) -> n.toString().contains(text));
    }

    public void not(APredicate<LNode> predicate) {
        filter(n -> !predicate.test(n));
    }

    public void reset() {
        predicate = APredicate.TRUE_STUB();
    }

    public void filterRegex(String expr) {
        var p = Pattern.compile(expr).asMatchPredicate();
        filter(n -> p.test(n.toString()));
    }

    public void notRegex(String expr) {
        var p = Pattern.compile(expr).asMatchPredicate();
        not(n -> p.test(n.toString()));
    }

    void debugOff() {
        not(n -> n.check(Log.LEVEL, Log.Level.DEBUG));
    }

    void traceOff() {
        not(n -> n.check(Log.LEVEL, Log.Level.TRACE));
    }

    void infoOff() {
        not(n -> n.check(Log.LEVEL, Log.Level.INFO));
    }

    void warnOff() {
        not(n -> n.check(Log.LEVEL, Log.Level.WARN));
    }

    void errorOff() {
        not(n -> n.check(Log.LEVEL, Log.Level.ERROR));
    }

    public void filter(APredicate<LNode> predicate) {
        while (true) {
            var old = this.predicate;
            if (PRED_UPDATER.compareAndSet(this, old, new APredicate<LNode>() {
                Exception errorFlag;

                @Override
                public boolean test2(LNode n) {
                    if (errorFlag != null) return true;
                    try {
                        if (!old.test(n)) {
                            return false;
                        }
                    } catch (Exception e) {
                        if (errorFlag == null) {
                            errorFlag = e;
                            Log.error("logger filter exception", e);
                        } else {
                            errorFlag = e;
                        }
                    }
                    try {
                        if (!predicate.test(n)) {
                            return false;
                        }
                    } catch (Exception e) {
                        if (errorFlag == null) {
                            errorFlag = e;
                            Log.warn("logger filter exception", e);
                        } else {
                            errorFlag = e;
                        }
                    }
                    return true;
                }
            })) return;
        }
    }
}
