package io.aether.utils;

import io.aether.utils.slots.EventConsumer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

public class QueueWithEvents<T> implements Queue<T> {
    public final EventConsumer<QueueWithEvents<T>> onAdd = new EventConsumer<>();
    private final Queue<T> target;

    public QueueWithEvents() {
        this(new ConcurrentLinkedQueue<>());
    }

    public QueueWithEvents(Queue<T> target) {
        this.target = target;
    }

    @Override
    public boolean add(T t) {
        boolean result = target.add(t);
        if (result) {
            onAdd.fire(this);
        }
        return result;
    }

    @Override
    public boolean offer(T t) {
        boolean result = target.offer(t);
        if (result) {
            onAdd.fire(this);
        }
        return result;
    }

    @Override
    public T remove() {
        return target.remove();
    }

    @Override
    public T poll() {
        return target.poll();
    }

    @Override
    public T element() {
        return target.element();
    }

    @Override
    public T peek() {
        return target.peek();
    }

    @Override
    public int size() {
        return target.size();
    }

    @Override
    public boolean isEmpty() {
        return target.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return target.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return target.iterator();
    }

    @Override
    public Object[] toArray() {
        return target.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return target.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return target.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return target.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }

        boolean result = target.addAll(c);
        if (result) {
            onAdd.fire(this);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return target.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return target.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return target.retainAll(c);
    }

    @Override
    public void clear() {
        target.clear();
    }

    public Queue<T> getTargetQueue() {
        return target;
    }

    public boolean hasListeners() {
        return onAdd.hasListener();
    }
}