package io.aether.utils;

import org.jetbrains.annotations.NotNull;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

public class WeakCollection<T> implements Iterable<T> {
    private final ConcurrentLinkedQueue<WeakReference<T>> q = new ConcurrentLinkedQueue<>();
    public int size(){
        return q.size();
    }
    public boolean isEmpty() {
        return q.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (var e : q) {
            var v = e.get();
            if (v != null) action.accept(v);
        }
    }

    public Object add(T entry) {
        var res = new WeakReference<>(entry);
        q.add(res);
        return res;
    }

    public void remove(Object key) {
        q.removeIf(v -> {
            var vv = v.get();
            return vv == null || vv == key;
        });
    }

    @Override
    public @NotNull Iterator<T> iterator() {
        var t = q.iterator();
        return new Iterator<>() {
            T val;

            @Override
            public boolean hasNext() {
                while (val == null) {
                    if (t.hasNext()) {
                        val = t.next().get();
                    } else {
                        break;
                    }
                }
                return val != null;
            }

            @Override
            public T next() {
                var res = val;
                val = null;
                return res;
            }
        };
    }
}
