package io.aether.utils;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.Writer;

public class WriterByAppender extends Writer {
    private final Appendable sb;

    public WriterByAppender(Appendable sb) {
        this.sb = sb;
    }

    @Override
    public void write(char @NotNull [] cbuf, int off, int len) throws IOException {
        sb.append(new CharSequenceByArray(cbuf, off, off + len));
    }

    @Override
    public void flush() throws IOException {

    }

    @Override
    public void close() throws IOException {

    }
}
