package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.interfaces.*;
import it.unimi.dsi.fastutil.booleans.*;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;

public interface FlowBoolean extends BooleanIterator, BooleanIterable {
	static final boolean[] EMPTY_AR = new boolean[0];
	FlowBoolean EMPTY = new FlowCompletedBoolean() {
		@Override
		public boolean hasNext() {
			return false;
		}
		@Override
		public boolean nextBoolean() {
			return false;
		}
		@Override
		public int count() {
			return 0;
		}
		@Override
		public boolean @NotNull [] toArray() {
			return EMPTY_AR;
		}
		@Override
		public @NotNull BooleanList toList() {
			return new BooleanArrayList();
		}
		@Override
		public @NotNull <K, V> Map<K, V> toMap(AFunctionBool2O<K> keyFactory, AFunctionBool2O<V> valFactory) {
			return new Object2ObjectOpenHashMap<>();
		}
	};

	default Flow<Boolean> box() {
		var self = this;
		return new Flow<>() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Boolean next() {
				return self.nextBoolean();
			}
		};
	}

    @NotNull
	static FlowBoolean of(@NotNull FlowBoolean stream) {
		return stream;
	}
	@NotNull
	static FlowBoolean of(boolean... array) {
		if (array.length == 0) return of();
		return new FlowCompletedBoolean() {
			int pos;
			@Override
			public boolean hasNext() {
				return pos < array.length;
			}
			@Override
			public boolean nextBoolean() {
				return array[pos++];
			}
			@Override
			public boolean @NotNull [] toArray() {
				return array;
			}
			@Override
			public void foreach(AConsumer<Boolean> c) {
				for (var v : array) {
					c.accept(v);
				}
			}
			@Override
			public int count() {
				return array.length;
			}
			@Override
			public @NotNull BooleanList toList() {
				return new BooleanArrayList(array);
			}
			@Override
			public @NotNull ASupplierBoolean toSupplier() {
				return new ASupplierBoolean() {
					int pos;
					@Override
					public boolean get2() {
						if (pos == array.length) throw new NoSuchElementException();
						return array[pos++];
					}
				};
			}
		};
	}
	@NotNull
	static FlowBoolean of(@NotNull BooleanIterable iterable) {
		if (iterable instanceof BooleanSet) return of((BooleanSet)iterable);
		if (iterable instanceof BooleanList) return of((BooleanList)iterable);
		return of(iterable.iterator());
	}
	@NotNull
	static FlowBoolean of(@NotNull BooleanSet collection) {
		if (collection.isEmpty()) return of();
		var it = collection.iterator();
		return new FlowCompletedBoolean() {
			@Override
			public int count() {
				return collection.size();
			}
			@Override
			public boolean hasNext() {
				return it.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				return it.nextBoolean();
			}
			@Override
			public @NotNull BooleanSet toSet() {
				return collection;
			}
		};
	}
	@NotNull
	static FlowBoolean of(@NotNull BooleanList collection) {
		if (collection.isEmpty()) return of();
		var it = collection.iterator();
		return new FlowCompletedBoolean() {
			@Override
			public int count() {
				return collection.size();
			}
			@Override
			public boolean hasNext() {
				return it.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				return it.nextBoolean();
			}
			@Override
			public @NotNull BooleanList toList() {
				return collection;
			}
		};
	}
	@NotNull
	static FlowBoolean of(@NotNull BooleanIterator iterator) {
		if (!iterator.hasNext()) return of();
		return new FlowBoolean() {
			@Override
			public boolean hasNext() {
				return iterator.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				return iterator.nextBoolean();
			}
		};
	}
	static FlowBoolean of() {
		return EMPTY;
	}
	static void quickSort(int[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
		int leftMarker = leftBorder;
		int rightMarker = rightBorder;
		int pivot = source[(leftMarker + rightMarker) / 2];
		do {
			while (comparator.compare(source[leftMarker], pivot) < 0) {
				leftMarker++;
			}
			while (comparator.compare(source[rightMarker], pivot) > 0) {
				rightMarker--;
			}
			if (leftMarker <= rightMarker) {
				if (leftMarker < rightMarker) {
					int tmp = source[leftMarker];
					source[leftMarker] = source[rightMarker];
					source[rightMarker] = tmp;
				}
				leftMarker++;
				rightMarker--;
			}
		} while (leftMarker <= rightMarker);
		if (leftMarker < rightBorder) {
			quickSort(source, leftMarker, rightBorder, comparator);
		}
		if (leftBorder < rightMarker) {
			quickSort(source, leftBorder, rightMarker, comparator);
		}
	}
	@NotNull
	@Override
	default BooleanIterator iterator() {
		return this;
	}
	default boolean random() {
		var ar = toArray();
		return ar[Flow.RANDOM.nextInt(ar.length)];
	}
	default boolean anyMatch(APredicateBoolean p) {
		while (hasNext()) {
			if (p.test(nextBoolean())) return true;
		}
		return false;
	}
	default boolean noneMatch(APredicateBoolean p) {
		while (hasNext()) {
			if (p.test(nextBoolean())) return false;
		}
		return true;
	}
	default FlowBoolean add(boolean value) {
		final var oit = this;
		return new FlowBoolean() {
			private boolean index;
			@Override
			public boolean hasNext() {
				return !index || oit.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				if (!index) {
					index = true;
					return value;
				}
				return oit.nextBoolean();
			}
		};
	}
	default boolean allMatch(APredicateBoolean p) {
		while (hasNext()) {
			if (!p.test(nextBoolean())) return false;
		}
		return true;
	}
	@NotNull
	default <E> Flow<E> mapToObj(@NotNull AFunctionBool2O<E> f) {
		final var self = this;
		return new Flow<>() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
			@Override
			public E next() {
				return f.apply(self.nextBoolean());
			}
		};
	}
	@NotNull
	default FlowBoolean apply(AConsumerBoolean c) {
		final var self = this;
		return new FlowBoolean() {
			@Override
			public boolean hasNext() {
				return self.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				var v = self.nextBoolean();
				c.accept(v);
				return v;
			}
		};
	}
	default FlowBoolean addAllEls(boolean... values) {
		final var oit = this;
		return new FlowBoolean() {
			private int index;
			@Override
			public boolean hasNext() {
				return index < values.length || oit.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				if (index < values.length) {
					return values[index++];
				}
				return oit.nextBoolean();
			}
		};
	}
	default FlowBoolean addAll(FlowBoolean values) {
		return addAll((BooleanIterator) values);
	}
	default FlowBoolean addAll(BooleanIterator values) {
		if (!values.hasNext()) return this;
		final var oit = this;
		return new FlowBoolean() {
			@Override
			public boolean hasNext() {
				return values.hasNext() || oit.hasNext();
			}
			@Override
			public boolean nextBoolean() {
				if (values.hasNext()) {
					return values.nextBoolean();
				}
				return oit.nextBoolean();
			}
		};
	}
	default FlowBoolean addAll(BooleanIterable values) {
		return addAll(values.iterator());
	}
	default void foreach(AConsumer<Boolean> c) {
		while (hasNext()) {
			c.accept(nextBoolean());
		}
	}
	@NotNull
	default FlowBoolean flatMap(@NotNull ABiConsumerBool2O<AConsumerBoolean> f) {
		final var oit = this;
		BooleanArrayList list = new BooleanArrayList();
		final AConsumerBoolean cc = list::add;
		return new FlowBoolean() {
			int pos;
			@Override
			public boolean hasNext() {
				while (list.isEmpty()) {
					if (!oit.hasNext()) return false;
					f.accept(oit.nextBoolean(), cc);
				}
				return true;
			}
			@Override
			public boolean nextBoolean() {
				var res = list.getBoolean(pos++);
				if (pos == list.size()) {
					pos = 0;
					list.clear();
				}
				return res;
			}
		};
	}
	default boolean @NotNull [] toArray() {
		boolean[] res = new boolean[10];
		int i = 0;
		while (hasNext()) {
			if (i == res.length) {
				res = Arrays.copyOf(res, (int) (res.length * 1.5));
			}
			res[i++] = nextBoolean();
		}
		return Arrays.copyOf(res, i);
	}
	default <E extends Collection<Boolean>> E toCollection(@NotNull E collection) {
		while (hasNext()) {
			collection.add(nextBoolean());
		}
		return collection;
	}
	default <E extends BooleanCollection> E toCollection(@NotNull E collection) {
		while (hasNext()) {
			collection.add(nextBoolean());
		}
		return collection;
	}
	@NotNull
	default FlowBoolean filter(@Nullable APredicateBoolean predicate) {
		if (predicate == null) return this;
		var oit = this;
		return new FlowBoolean() {
			boolean last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					last = oit.nextBoolean();
					if (predicate.test(last)) {
						hasNext = true;
						return true;
					}
				}
				return false;
			}
			@Override
			public boolean nextBoolean() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default FlowBoolean filterNot(@Nullable APredicateBoolean predicate) {
		if (predicate == null) return this;
		var oit = this;
		return new FlowBoolean() {
			boolean last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					last = oit.nextBoolean();
					if (!predicate.test(last)) {
						hasNext = true;
						return true;
					}
				}
				return false;
			}
			@Override
			public boolean nextBoolean() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default FlowBoolean ifEmpty(ARunnable task) {
		if (task == null) return this;
		var oit = this;
		return new FlowBoolean() {
			boolean first = true;
			@Override
			public boolean hasNext() {
				var res = oit.hasNext();
				if (!res && first) {
					task.run();
				}
				first = false;
				return res;
			}
			@Override
			public boolean nextBoolean() {
				return oit.nextBoolean();
			}
		};
	}
	@NotNull
	default FlowBoolean ifEmpty(Exception error) {
		return ifEmpty(() -> {
			throw error;
		});
	}
	@NotNull
	default FlowBoolean ignoreError(Class<? extends Exception> ee) {
		if (ee == null) return this;
		var oit = this;
		return new FlowBoolean() {
			boolean last;
			boolean hasNext;
			@Override
			public boolean hasNext() {
				if (hasNext) return true;
				while (oit.hasNext()) {
					try {
						last = oit.nextBoolean();
						hasNext = true;
						return true;
					} catch (Exception ex) {
						if (!ee.isInstance(ex)) {
							RU.error(ex);
						}
					}
				}
				return false;
			}
			@Override
			public boolean nextBoolean() {
				assert hasNext;
				hasNext = false;
				return last;
			}
		};
	}
	@NotNull
	default BooleanIterable toIterable() {
		return () -> this;
	}
	@NotNull
	default BooleanList toList() {
		return new BooleanArrayList(toArray());
	}
	@NotNull
	default BooleanSet toSet() {
		return new BooleanOpenHashSet(toArray());
	}
	default void to(AConsumerBoolean consumer) {
		while (hasNext()) {
			consumer.accept(nextBoolean());
		}
	}
	default <E> E streamTo(AFunction<FlowBoolean, E> consumer) {
		return consumer.apply(this);
	}
	@NotNull
	default ASupplierBoolean toSupplier() {
		return () -> {
			if (hasNext()) {
				return nextBoolean();
			}
			throw new NoSuchElementException();
		};
	}
	@NotNull
	default <K, V> Map<K, V> toMap(AFunctionBool2O<K> keyFactory, AFunctionBool2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>();
		while (hasNext()) {
			var val = nextBoolean();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	default String join(String delimer) {
		StringBuilder sb = new StringBuilder();
		boolean first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.append(delimer);
			}
			sb.append(nextBoolean());
		}
		return sb.toString();
	}
	default String join(AFunctionBool2O<Object> preparer, String delimer) {
		StringBuilder sb = new StringBuilder();
		var first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.append(delimer);
			}
			sb.append(preparer.apply(nextBoolean()));
		}
		return sb.toString();
	}
	default boolean getFirstOr(boolean def) {
		if (hasNext()) return nextBoolean();
		return def;
	}
	default boolean getFirst() {
		if (hasNext()) return nextBoolean();
		throw new NoSuchElementException();
	}
	default boolean getFirst(APredicateBoolean p) {
		return filter(p).getFirst();
	}
	default String join() {
		StringBuilder sb = new StringBuilder();
		while (hasNext()) {
			sb.append(nextBoolean());
		}
		return sb.toString();
	}
	default String join(String delim, String prefix, String postfix) {
		StringBuilder sb = new StringBuilder(prefix);
		var first = true;
		while (hasNext()) {
			if (first){
				first=false;
			}else{
				sb.append(delim);
			}
			sb.append(nextBoolean());
		}
		sb.append(postfix);
		return sb.toString();
	}
}
