package io.aether.utils.flow;

import io.aether.utils.RU;
import io.aether.utils.interfaces.AFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public interface FlowCompleted<T> extends Flow<T> {
	int count();
	@Override
	default T random() {
		var n = RANDOM.nextInt(count());
		for (int i = 0; i < n; i++) {
			next();
		}
		return next();
	}
	@Override
	default @NotNull List<T> toList() {
		var res = new ObjectArrayList<T>(count());
		while (hasNext()) {
			res.add(next());
		}
		return res;
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunction<T, K> keyFactory, AFunction<T, V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = next();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	@NotNull
	default T[] toArray(@NotNull Class<? super T> arrayType) {
		T[] res = RU.cast( Array.newInstance(arrayType, count()));
		int i = 0;
		while (hasNext()) {
			res[i++] = next();
		}
		return res;
	}
	@Override
	@NotNull
	default Object[] toArray() {
		Object[] res = new Object[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = next();
		}
		return res;
	}
}
