package io.aether.utils.flow;

import io.aether.utils.interfaces.AFunctionBool2O;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public interface FlowCompletedBoolean extends FlowBoolean {
	int count();
	default Flow<Boolean> box() {
		var self = this;
		return new FlowCompleted<>() {
			@Override
			public int count() {
				return self.count();
			}

			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Boolean next() {
				return self.nextBoolean();
			}
		};
	}
	@Override
	default @NotNull BooleanList toList() {
		var res = new BooleanArrayList(count());
		while (hasNext()) {
			res.add(nextBoolean());
		}
		return res;
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunctionBool2O<K> keyFactory, AFunctionBool2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = nextBoolean();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	default boolean @NotNull [] toArray() {
		boolean[] res = new boolean[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = nextBoolean();
		}
		return res;
	}
}
