package io.aether.utils.flow;

import io.aether.utils.interfaces.AFunctionB2O;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public interface FlowCompletedByte extends FlowByte {
	int count();
	@Override
	default @NotNull ByteList toList() {
		var res = new ByteArrayList(count());
		while (hasNext()) {
			res.add(nextByte());
		}
		return res;
	}
	default Flow<Byte> box(){
		var self=this;
		return new FlowCompleted<Byte>() {
			@Override
			public int count() {
				return self.count();
			}

			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Byte next() {
				return self.nextByte();
			}
		};
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = nextByte();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	default byte @NotNull [] toArray() {
		byte[] res = new byte[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = nextByte();
		}
		return res;
	}
}
