package io.aether.utils.flow;

import io.aether.utils.interfaces.AFunctionL2O;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public interface FlowCompletedInt extends FlowInt {
	int count();
	default Flow<Integer> box() {
		var self = this;
		return new FlowCompleted<>() {
			@Override
			public int count() {
				return self.count();
			}

			@Override
			public boolean hasNext() {
				return self.hasNext();
			}

			@Override
			public Integer next() {
				return self.nextInt();
			}
		};
	}
	@Override
	default @NotNull IntList toList() {
		var res = new IntArrayList(count());
		while (hasNext()) {
			res.add(nextInt());
		}
		return res;
	}
	@Override
	default @NotNull <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
		Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>(count());
		while (hasNext()) {
			var val = nextInt();
			res.put(keyFactory.apply(val), valFactory.apply(val));
		}
		return res;
	}
	@Override
	default int @NotNull [] toArray() {
		int[] res = new int[count()];
		int i = 0;
		while (hasNext()) {
			res[i++] = nextInt();
		}
		return res;
	}
}
