package io.aether.utils.flow;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.interfaces.*;
import it.unimi.dsi.fastutil.ints.*;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;

public interface FlowInt extends IntIterator, IntIterable {
    static final int[] EMPTY_AR = new int[0];
    FlowInt EMPTY = new FlowCompletedInt() {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            return 0;
        }

        @Override
        public int count() {
            return 0;
        }

        @Override
        public int @NotNull [] toArray() {
            return EMPTY_AR;
        }

        @Override
        public @NotNull IntList toList() {
            return new IntArrayList();
        }

        @Override
        public @NotNull <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
            return new Object2ObjectOpenHashMap<>();
        }
    };

    default Flow<Integer> box() {
        var self = this;
        return new Flow<>() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Integer next() {
                return self.nextInt();
            }
        };
    }

    @NotNull
    static FlowInt of(@NotNull FlowInt stream) {
        return stream;
    }

    @NotNull
    static FlowInt of(int... array) {
        if (array.length == 0) return of();
        return new FlowCompletedInt() {
            int pos;

            @Override
            public boolean hasNext() {
                return pos < array.length;
            }

            @Override
            public int nextInt() {
                return array[pos++];
            }

            @Override
            public int @NotNull [] toArray() {
                return array;
            }

            @Override
            public void foreach(AConsumer<Integer> c) {
                for (var v : array) {
                    c.accept(v);
                }
            }

            @Override
            public int count() {
                return array.length;
            }

            @Override
            public @NotNull IntList toList() {
                return new IntArrayList(array);
            }

            @Override
            public @NotNull ASupplierInt toSupplier() {
                return new ASupplierInt() {
                    int pos;

                    @Override
                    public int get2() {
                        if (pos == array.length) throw new NoSuchElementException();
                        return array[pos++];
                    }
                };
            }
        };
    }

    @NotNull
    static FlowInt of(@NotNull IntIterable iterable) {
        if (iterable instanceof IntSet) return of((IntSet) iterable);
        if (iterable instanceof IntList) return of((IntList) iterable);
        return of(iterable.iterator());
    }

    @NotNull
    static FlowInt of(@NotNull IntSet collection) {
        if (collection.isEmpty()) return of();
        var it = collection.iterator();
        return new FlowCompletedInt() {
            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public int nextInt() {
                return it.nextInt();
            }

            @Override
            public @NotNull IntSet toSet() {
                return collection;
            }
        };
    }

    @NotNull
    static FlowInt of(@NotNull IntList collection) {
        if (collection.isEmpty()) return of();
        var it = collection.iterator();
        return new FlowCompletedInt() {
            @Override
            public int count() {
                return collection.size();
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public int nextInt() {
                return it.nextInt();
            }

            @Override
            public @NotNull IntList toList() {
                return collection;
            }
        };
    }

    @NotNull
    static FlowInt of(@NotNull IntIterator iterator) {
        if (!iterator.hasNext()) return of();
        return new FlowInt() {
            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return iterator.nextInt();
            }
        };
    }

    static FlowInt of() {
        return EMPTY;
    }

    static void quickSort(int[] source, int leftBorder, int rightBorder, AComparatorInt comparator) {
        int leftMarker = leftBorder;
        int rightMarker = rightBorder;
        int pivot = source[(leftMarker + rightMarker) / 2];
        do {
            while (comparator.compare(source[leftMarker], pivot) < 0) {
                leftMarker++;
            }
            while (comparator.compare(source[rightMarker], pivot) > 0) {
                rightMarker--;
            }
            if (leftMarker <= rightMarker) {
                if (leftMarker < rightMarker) {
                    int tmp = source[leftMarker];
                    source[leftMarker] = source[rightMarker];
                    source[rightMarker] = tmp;
                }
                leftMarker++;
                rightMarker--;
            }
        } while (leftMarker <= rightMarker);
        if (leftMarker < rightBorder) {
            quickSort(source, leftMarker, rightBorder, comparator);
        }
        if (leftBorder < rightMarker) {
            quickSort(source, leftBorder, rightMarker, comparator);
        }
    }

    @NotNull
    @Override
    default IntIterator iterator() {
        return this;
    }

    default int random() {
        var ar = toArray();
        return ar[Flow.RANDOM.nextInt(ar.length)];
    }

    default boolean anyMatch(APredicateInt p) {
        while (hasNext()) {
            if (p.test(nextInt())) return true;
        }
        return false;
    }

    default boolean noneMatch(APredicateInt p) {
        while (hasNext()) {
            if (p.test(nextInt())) return false;
        }
        return true;
    }

    default FlowInt add(int value) {
        final var oit = this;
        return new FlowInt() {
            private boolean index;

            @Override
            public boolean hasNext() {
                return !index || oit.hasNext();
            }

            @Override
            public int nextInt() {
                if (!index) {
                    index = true;
                    return value;
                }
                return oit.nextInt();
            }
        };
    }

    default boolean noneMatchValue(int p) {
        while (hasNext()) {
            if (p == nextInt()) return false;
        }
        return true;
    }

    default boolean anyMatchValue(int p) {
        while (hasNext()) {
            if (p == nextInt()) return true;
        }
        return false;
    }

    default boolean allMatch(APredicateInt p) {
        while (hasNext()) {
            if (!p.test(nextInt())) return false;
        }
        return true;
    }

    @NotNull
    default <E> Flow<E> mapToObj(@NotNull AFunctionI2O<E> f) {
        final var self = this;
        return new Flow<>() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public E next() {
                return f.apply(self.nextInt());
            }
        };
    }

    @NotNull
    default FlowInt map(@NotNull AFunctionI2I f) {
        final var self = this;
        return new FlowInt() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public int nextInt() {
                return f.apply(self.nextInt());
            }
        };
    }

    @NotNull
    default FlowByte mapToByte() {
        final var self = this;
        return new FlowByte() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public byte nextByte() {
                return (byte) self.nextInt();
            }
        };
    }

    @NotNull
    default FlowInt apply(AConsumerInt c) {
        final var self = this;
        return new FlowInt() {
            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public int nextInt() {
                var v = self.nextInt();
                c.accept(v);
                return v;
            }
        };
    }

    default FlowInt addAllEls(int... values) {
        final var oit = this;
        return new FlowInt() {
            private int index;

            @Override
            public boolean hasNext() {
                return index < values.length || oit.hasNext();
            }

            @Override
            public int nextInt() {
                if (index < values.length) {
                    return values[index++];
                }
                return oit.nextInt();
            }
        };
    }

    default FlowInt addAll(FlowInt values) {
        return addAll((IntIterator) values);
    }

    default FlowInt addAll(IntIterator values) {
        if (!values.hasNext()) return this;
        final var oit = this;
        return new FlowInt() {
            @Override
            public boolean hasNext() {
                return values.hasNext() || oit.hasNext();
            }

            @Override
            public int nextInt() {
                if (values.hasNext()) {
                    return values.nextInt();
                }
                return oit.nextInt();
            }
        };
    }

    default FlowInt addAll(IntIterable values) {
        return addAll(values.iterator());
    }

    @NotNull
    default FlowInt flatMap(@NotNull AFunctionL2IterableInt f) {
        return flatMap((e, c) -> {
            var ii = f.apply(e);
            if (ii != null) {
                for (var v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    @NotNull
    default FlowInt flatMap(@NotNull AFunctionI2Array f) {
        return flatMap((e, c) -> {
            var ii = f.apply(e);
            if (ii != null) {
                for (var v : ii) {
                    c.accept(v);
                }
            }
        });
    }

    default void foreach(AConsumer<Integer> c) {
        while (hasNext()) {
            c.accept(nextInt());
        }
    }

    @NotNull
    default FlowInt flatMap(@NotNull AFunctionL2StreamInt f) {
        var self = this;
        return new FlowInt() {
            FlowInt cur;

            @Override
            public boolean hasNext() {
                while (cur == null || !cur.hasNext()) {
                    if (cur != null) {
                        cur = null;
                    }
                    if (!self.hasNext()) return false;
                    cur = f.apply(self.nextInt());
                }
                return true;
            }

            @Override
            public int nextInt() {
                return cur.nextInt();
            }
        };
    }

    @NotNull
    default FlowInt flatMap(@NotNull ABiConsumerI2O<AConsumerInt> f) {
        final var oit = this;
        IntArrayList list = new IntArrayList();
        final AConsumerInt cc = list::add;
        return new FlowInt() {
            int pos;

            @Override
            public boolean hasNext() {
                while (list.isEmpty()) {
                    if (!oit.hasNext()) return false;
                    f.accept(oit.nextInt(), cc);
                }
                return true;
            }

            @Override
            public int nextInt() {
                var res = list.getInt(pos++);
                if (pos == list.size()) {
                    pos = 0;
                    list.clear();
                }
                return res;
            }
        };
    }

    default short @NotNull [] toShortArray() {
        short[] res = new short[10];
        int i = 0;
        while (hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int) (res.length * 1.5));
            }
            res[i++] = (short) nextInt();
        }
        return Arrays.copyOf(res, i);
    }

    default int @NotNull [] toArray() {
        int[] res = new int[10];
        int i = 0;
        while (hasNext()) {
            if (i == res.length) {
                res = Arrays.copyOf(res, (int) (res.length * 1.5));
            }
            res[i++] = nextInt();
        }
        return Arrays.copyOf(res, i);
    }

    default <E extends Collection<Integer>> E toCollection(@NotNull E collection) {
        while (hasNext()) {
            collection.add(nextInt());
        }
        return collection;
    }

    default <E extends IntCollection> E toCollection(@NotNull E collection) {
        while (hasNext()) {
            collection.add(nextInt());
        }
        return collection;
    }

    @NotNull
    default FlowInt filter(@Nullable APredicateInt predicate) {
        if (predicate == null) return this;
        var oit = this;
        return new FlowInt() {
            int last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    last = oit.nextInt();
                    if (predicate.test(last)) {
                        hasNext = true;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int nextInt() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowInt filterNot(@Nullable APredicateInt predicate) {
        if (predicate == null) return this;
        var oit = this;
        return new FlowInt() {
            int last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    last = oit.nextInt();
                    if (!predicate.test(last)) {
                        hasNext = true;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int nextInt() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowInt ifEmpty(ARunnable task) {
        if (task == null) return this;
        var oit = this;
        return new FlowInt() {
            boolean first = true;

            @Override
            public boolean hasNext() {
                var res = oit.hasNext();
                if (!res && first) {
                    task.run();
                }
                first = false;
                return res;
            }

            @Override
            public int nextInt() {
                return oit.nextInt();
            }
        };
    }

    @NotNull
    default FlowInt ifEmpty(Exception error) {
        return ifEmpty(() -> {
            throw error;
        });
    }

    @NotNull
    default FlowInt ignoreError(Class<? extends Exception> ee) {
        if (ee == null) return this;
        var oit = this;
        return new FlowInt() {
            int last;
            boolean hasNext;

            @Override
            public boolean hasNext() {
                if (hasNext) return true;
                while (oit.hasNext()) {
                    try {
                        last = oit.nextInt();
                        hasNext = true;
                        return true;
                    } catch (Exception ex) {
                        if (!ee.isInstance(ex)) {
                            RU.error(ex);
                        }
                    }
                }
                return false;
            }

            @Override
            public int nextInt() {
                assert hasNext;
                hasNext = false;
                return last;
            }
        };
    }

    @NotNull
    default FlowInt sort(@NotNull AComparatorInt comparator) {
        int[] arr = toArray();
        quickSort(arr, 0, arr.length, comparator);
        return of(arr);
    }

    @NotNull
    default IntIterable toIterable() {
        return () -> this;
    }

    @NotNull
    default IntList toList() {
        return new IntArrayList(toArray());
    }

    @NotNull
    default IntSet toSet() {
        return new IntOpenHashSet(toArray());
    }

    default void to(AConsumerInt consumer) {
        while (hasNext()) {
            consumer.accept(nextInt());
        }
    }

    default <E> E streamTo(AFunction<FlowInt, E> consumer) {
        return consumer.apply(this);
    }

    @NotNull
    default ASupplierInt toSupplier() {
        return () -> {
            if (hasNext()) {
                return nextInt();
            }
            throw new NoSuchElementException();
        };
    }

    @NotNull
    default <K, V> Map<K, V> toMap(AFunctionL2O<K> keyFactory, AFunctionL2O<V> valFactory) {
        Object2ObjectOpenHashMap<K, V> res = new Object2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <V> Int2ObjectMap<V> toMapI2O(AFunctionL2I keyFactory, AFunctionL2O<V> valFactory) {
        Int2ObjectOpenHashMap<V> res = new Int2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <K> Object2IntMap<K> toMapO2I(AFunctionL2O<K> keyFactory, AFunctionI2I valFactory) {
        Object2IntOpenHashMap<K> res = new Object2IntOpenHashMap<>();
        while (hasNext()) {
            var val = nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @NotNull
    default <V> Int2ObjectMap<V> toMapL2O(AFunctionI2I keyFactory, AFunctionI2O<V> valFactory) {
        Int2ObjectOpenHashMap<V> res = new Int2ObjectOpenHashMap<>();
        while (hasNext()) {
            var val = nextInt();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    default String join(String delimer) {
        AString sb = AString.of();
        join(sb, delimer);
        return sb.toString();
    }

    default void join(AString sb, String delimer) {
        boolean first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.add(delimer);
            }
            sb.add(nextInt());
        }
    }

    default FlowInt distinct() {
        return filter(new APredicateInt() {
            private final IntSet old = new IntOpenHashSet();

            public boolean test2(int value) {
                return old.add(value);
            }
        });
    }

    default String join(AFunctionL2O<Object> preparer, String delimer) {
        StringBuilder sb = new StringBuilder();
        var first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimer);
            }
            sb.append(preparer.apply(nextInt()));
        }
        return sb.toString();
    }

    default int getFirstOr(int def) {
        if (hasNext()) return nextInt();
        return def;
    }

    default int getFirst() {
        if (hasNext()) return nextInt();
        throw new NoSuchElementException();
    }

    default int getFirst(APredicateInt p) {
        return filter(p).getFirst();
    }

    default String join() {
        StringBuilder sb = new StringBuilder();
        while (hasNext()) {
            sb.append(nextInt());
        }
        return sb.toString();
    }

    default String join(String delim, String prefix, String postfix) {
        StringBuilder sb = new StringBuilder(prefix);
        var first = true;
        while (hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            sb.append(nextInt());
        }
        sb.append(postfix);
        return sb.toString();
    }

    default int min(AComparatorInt comparator) {
        int min = Integer.MAX_VALUE;
        while (hasNext()) {
            var v = nextInt();
            if (comparator.compare(min, v) > 0) {
                min = v;
            }
        }
        return min;
    }

    default int min() {
        int min = Integer.MAX_VALUE;
        while (hasNext()) {
            var v = nextInt();
            if (min > v) {
                min = v;
            }
        }
        return min;
    }

    default int max(AComparatorInt comparator) {
        int max = Integer.MIN_VALUE;
        while (hasNext()) {
            var v = nextInt();
            if (comparator.compare(max, v) < 0) {
                max = v;
            }
        }
        return max;
    }

    default int max() {
        int max = Integer.MIN_VALUE;
        while (hasNext()) {
            var v = nextInt();
            if (max < v) {
                max = v;
            }
        }
        return max;
    }

    default int sum() {
        int res = 0;
        while (hasNext()) {
            res += nextInt();
        }
        return res;
    }

    default int avg() {
        long sum = 0;
        int count = 0;
        while (hasNext()) {
            sum += nextInt();
            count++;
        }
        return (int) (sum / count);
    }
}
