package io.aether.utils.interfaces;

import io.aether.logger.LNode;
import io.aether.utils.RU;

public interface A3Predicate<T, E, F> {
    A3Predicate<?, ?, ?> TRUE_STUB = (v1, v2, v3) -> true;
    A3Predicate<?, ?, ?> FALSE_STUB = (v1, v2, v3) -> false;

    boolean test2(T value1, E value2, F value3);

    default boolean test(T value1, E value2, F value3) {
        try {
            return test2(value1, value2, value3);
        } catch (Exception e) {
            return RU.error(e);
        }
    }

    default A3Predicate<T, E, F> and(A3Predicate<T, E, F> p) {
        return (v1, v2, v3) -> A3Predicate.this.test(v1, v2, v3) && p.test(v1, v2, v3);
    }

    static A3Predicate<LNode, String, Object> TRUE_STUB() {
        return RU.cast(TRUE_STUB);
    }

    static A3Predicate<LNode, String, Object> FALSE_STUB() {
        return RU.cast(FALSE_STUB);
    }
}
