package io.aether.utils.interfaces;

import io.aether.utils.RU;

import java.util.function.BiConsumer;

public interface ABiConsumer<T, E> extends BiConsumer<T, E> {
    ABiConsumer<?, ?> empty = (a1, a2) -> {
    };

    static <T1, T2> ABiConsumer<T1, T2> empty() {
        return RU.cast(empty);
    }

    @Override
    default void accept(T t, E t2) {
        try {
            accept2(t, t2);
        } catch (Throwable e) {
            RU.error(e);
        }
    }

    void accept2(T v, E t2) throws Throwable;
}
