package io.aether.utils.interfaces;

import io.aether.utils.RU;

import java.util.function.Function;

public interface AFunction<T, R> extends Function<T, R> {
    AFunction<?, ?> repeat = new AFunctionEmpty();
    AFunction<?, ?> unsupported = new AFunctionUnsupported();

    default R apply(T v) {
        try {
            return apply2(v);
        } catch (Throwable e) {
            return RU.error(e);
        }
    }

    R apply2(T v) throws Throwable;

    static <T> AFunction<T, T> stub() {
        return RU.cast(repeat);
    }

    static <T, T2> AFunction<T, T2> unsupported() {
        return RU.cast(unsupported);
    }

    class AFunctionUnsupported implements AFunction<Object, Object> {
        @Override
        public Object apply2(Object v) throws Throwable {
            throw new UnsupportedOperationException();
        }
    }

    class AFunctionEmpty implements AFunction<Object, Object> {
        @Override
        public Object apply2(Object v) throws Throwable {
            return v;
        }
    }
}
