package io.aether.utils.interfaces;

import io.aether.utils.RU;

import java.util.function.Predicate;

public interface APredicate<T> extends Predicate<T> {
    APredicate<?> TRUE_STUB = v -> true;
    APredicate<?> FALSE_STUB = v -> false;

    default APredicate<T> and(APredicate<T> p) {
        var self = this;
        return v -> self.test(v) && p.test(v);
    }

    boolean test2(T value);

    @Override
    default boolean test(T t) {
        try {
            return test2(t);
        } catch (Throwable e) {
            return RU.error(e);
        }
    }

    static <T> APredicate<T> TRUE_STUB() {
        return RU.cast(TRUE_STUB);
    }

    static <T> APredicate<T> FALSE_STUB() {
        return RU.cast(FALSE_STUB);
    }
}
