package io.aether.utils.interfaces;

import io.aether.utils.futures.AFuture;

/**
 * The Destroyable interface represents an object that can be destroyed.
 * It provides a method to initiate the destruction process with an option to force it.
 */
public interface Destroyable {
    /**
     * Creates a new Destroyable instance with a specified name and delegate.
     *
     * @param name        The name of the destroyable instance.
     * @param destroyable The delegate Destroyable instance whose destroy method will be called.
     * @return A new Destroyable instance.
     */
    static Destroyable of(String name, Destroyable destroyable) {
        return new Destroyable() {
            @Override
            public String toString() {
                return name;
            }

            /**
             * Initiates the destruction process.
             *
             * @param force If true, forces the destruction; otherwise, attempts a graceful shutdown.
             * @return An AFuture representing the result of the destruction process.
             */
            @Override
            public AFuture destroy(boolean force) {
                return destroyable.destroy(force);
            }
        };
    }

    /**
     * Initiates the destruction process.
     *
     * @param force If true, forces the destruction; otherwise, attempts a graceful shutdown.
     * @return An AFuture representing the result of the destruction process.
     */
    AFuture destroy(boolean force);
}
