package io.aether.utils.interfaces;

import io.aether.utils.CTypeI;
import io.aether.utils.RU;

public interface ObjectFind {
    default <T> T find(Class<T> type) {
        if (type.isInstance(this)) return RU.cast(this);
        var oo = getOwners();
        if (oo != null) {
            for (var o : oo) {
                if (o instanceof ObjectFind) {
                    var r = ((ObjectFind) o).find(type);
                    if (r != null) return r;
                }
                if (type.isInstance(o)) return RU.cast(o);
            }
        }
        return null;
    }

    default Object[] getOwners() {
        return null;
    }

    default <T> T find(CTypeI<T> type) {
        if (type.isInstance(this)) return RU.cast(this);
        var oo = getOwners();
        if (oo != null) {
            for (var o : oo) {
                if (o instanceof ObjectFind) {
                    var r = ((ObjectFind) o).find(type);
                    if (r != null) return r;
                }
                if (type.isInstance(o)) return RU.cast(o);
            }
        }
        return null;
    }
}
