package io.aether.utils.rcollections;

import io.aether.utils.ConcurrentHashSet;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RCol {
    public static <T> RQueue<T> of(Queue<T> src) {
        return RQueue.of(src);
    }

    public static <T> RSet<T> of(Set<T> src) {
        return RSet.of(src);
    }

    public static <T> RCollection<T> of(Collection<T> src) {
        return RCollection.of(src);
    }

    public static <K, V> RMap<K, V> of(Map<K, V> src) {
        return RMap.of(src);
    }

    public static <K, V> RMap<K, V> map() {
        return of(new ConcurrentHashMap<>());
    }

    public static <T> RSet<T> set() {
        return of(new ConcurrentHashSet<>());
    }


    public static <T> RQueue<T> queue() {
        return of(new ConcurrentLinkedQueue<>());
    }

    /**
     * Creates an asynchronous Batching Map (BMap) implementation with specific metadata.
     *
     * @param timeoutMs The request timeout duration in milliseconds.
     * @param name      A descriptive name for logging purposes.
     * @param <K>       The type of keys.
     * @param <V>       The type of values.
     * @return A new BMap instance backed by BMapImpl.
     */
    public static <K, V> BMap<K, V> bMap(long timeoutMs, String name) {
        // Initializes BMapImpl, passing an empty ConcurrentHashMap and the metadata.
        return new BMapImpl<>(10, name, timeoutMs);
    }

    /**
     * Creates an asynchronous Batching Map (BMap) implementation with default parameters.
     *
     * @param <K> The type of keys.
     * @param <V> The type of values.
     * @return A new BMap instance with default parameters (4 seconds timeout, "GenericBMap").
     */
    public static <K, V> BMap<K, V> bMap() {
        // Delegates to the parameterized method with sensible defaults, consistent with AetherCloudClient use.
        return bMap(4000, "GenericBMap");
    }
}
