package io.aether.utils.rcollections;

import io.aether.utils.RU;
import io.aether.utils.slots.EventConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public class RMapBySrc<K, V> implements RMap<K, V> {

    public final EventConsumer<Update<K, V>> forUpdate = new EventConsumer<>();
    public final EventConsumer<Entry<K, V>> forRemove = new EventConsumer<>();
    private final Map<K, V> src;

    public RMapBySrc(Map<K, V> src) {
        this.src = src;
    }

    @Override
    public EventConsumer<Entry<K, V>> forRemove() {
        return forRemove;
    }

    @Override
    public EventConsumer<Update<K, V>> forUpdate() {
        return forUpdate;
    }

    @Override
    public int size() {
        return src.size();
    }

    @Override
    public boolean isEmpty() {
        return src.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return src.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return src.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return src.get(key);
    }

    @Override
    public @Nullable V put(K key, V value) {
        var old = src.put(key, value);
        if (old != value) {
            forUpdate.fire(new Update<>(key, value, old));
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        var old = src.remove(key);
        forRemove.fire(RU.cast(key));
        return old;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (var e : m.entrySet()) {
            put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        var it = entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public @NotNull RSet<K> keySet() {
        return RSet.of(src.keySet());//TODO
    }

    @Override
    public @NotNull RCollection<V> values() {
        return RCollection.of(src.values());
    }

    @Override
    public @NotNull RSet<Entry<K, V>> entrySet() {
        return RSet.of(src.entrySet());
    }

}
