package io.aether.utils.rcollections;

import io.aether.utils.RU;

import java.util.Queue;

public class RQueueBySrc<E> extends RCollectionBySrc<E> implements RQueue<E> {

    public RQueueBySrc(Queue<E> src) {
        super(src);
    }

    private Queue<E> queue() {
        return RU.cast(src);
    }

    @Override
    public boolean offer(E e) {
        if (queue().offer(e)) {
            forAdd.fire(e);
            return true;
        }
        return false;
    }

    @Override
    public E remove() {
        var v = queue().remove();
        forRemove.fire(v);
        return v;
    }

    @Override
    public E poll() {
        var v = queue().poll();
        if (v == null) return null;
        forRemove.fire(v);
        return v;
    }

    @Override
    public E element() {
        return queue().element();
    }

    @Override
    public E peek() {
        return queue().peek();
    }
}
