/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.CharSequenceByArray;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.AFunction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public interface AString
extends CharSequence {
    public static final ABiConsumer<?, AString> DEFAULT_RENDERER = (v, s) -> s.add(String.valueOf(v));
    public static final Map<Class<?>, ABiConsumer<?, AString>> renderers = new ConcurrentHashMap<Class<?>, ABiConsumer<?, AString>>(){
        {
            this.putRenderer(ToString.class, (v, s) -> s.add((ToString)v));
            this.putRenderer(byte[].class, (v, s) -> s.add((byte[])v));
            this.putRenderer(short[].class, (v, s) -> s.add((short[])v));
            this.putRenderer(int[].class, (v, s) -> s.add((int[])v));
            this.putRenderer(long[].class, (v, s) -> s.add((long[])v));
            this.putRenderer(float[].class, (v, s) -> s.add((float[])v));
            this.putRenderer(double[].class, (v, s) -> s.add((double[])v));
            this.putRenderer(char[].class, (v, s) -> s.add((char[])v));
            this.putRenderer(String.class, (v, s) -> s.add((String)v));
            this.putRenderer(Byte.class, (v, s) -> s.add((byte)v));
            this.putRenderer(Short.class, (v, s) -> s.add((short)v));
            this.putRenderer(Integer.class, (v, s) -> s.add((int)v));
            this.putRenderer(Long.class, (v, s) -> s.add((long)v));
            this.putRenderer(Float.class, (v, s) -> s.add(v.floatValue()));
            this.putRenderer(Double.class, (v, s) -> s.add((double)v));
            this.putRenderer(CharSequence.class, (v, s) -> s.add((CharSequence)v));
            this.putRenderer(Character.class, (v, s) -> s.add(v.charValue()));
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM:dd:HH:mm:ss.SSSS");
            this.putRenderer(Date.class, (v, s) -> s.add(DATE_FORMAT.format((Date)v)));
            this.putRenderer(Boolean.class, (v, s) -> s.add((boolean)v));
            this.putRenderer(SoftReference.class, (v, s) -> {
                Object vv = v.get();
                s.add(vv);
            });
            this.putRenderer(Throwable.class, (v, s) -> {
                s.add(v.getClass().getSimpleName()).add("(");
                if (v.getMessage() != null) {
                    s.add(v.getMessage());
                }
                s.add(")");
            });
            this.putRenderer(UUID.class, (v, sb) -> {
                long vv = v.getMostSignificantBits();
                HexUtils.toHexString(vv >> 56, sb);
                HexUtils.toHexString(vv >> 48, sb);
                HexUtils.toHexString(vv >> 40, sb);
                HexUtils.toHexString(vv >> 32, sb);
                sb.add('-');
                HexUtils.toHexString(vv >> 24, sb);
                HexUtils.toHexString(vv >> 16, sb);
                sb.add('-');
                HexUtils.toHexString(vv >> 8, sb);
                HexUtils.toHexString(vv >> 0, sb);
                sb.add('-');
                vv = v.getLeastSignificantBits();
                HexUtils.toHexString(vv >> 56, sb);
                HexUtils.toHexString(vv >> 48, sb);
                sb.add('-');
                HexUtils.toHexString(vv >> 40, sb);
                HexUtils.toHexString(vv >> 32, sb);
                HexUtils.toHexString(vv >> 24, sb);
                HexUtils.toHexString(vv >> 16, sb);
                HexUtils.toHexString(vv >> 8, sb);
                HexUtils.toHexString(vv >> 0, sb);
            });
        }

        <T> void putRenderer(Class<T> cl, ABiConsumer<T, AString> f) {
            this.put(cl, f);
        }
    };

    default public AString limit(final int count) {
        final AString self = this;
        return new AString(){
            int limit;
            boolean end;
            {
                this.limit = count - 3;
                this.end = false;
            }

            private void end() {
                if (this.end) {
                    return;
                }
                self.add("...");
                this.end = true;
            }

            @Override
            @NotNull
            public String toString() {
                return self.toString();
            }

            @Override
            public AString add(CharSequence val) {
                if (val.length() == 0) {
                    return this;
                }
                if (val.length() == this.limit) {
                    this.limit = 0;
                    self.add(val);
                } else if (val.length() <= this.limit) {
                    this.limit -= val.length();
                    self.add(val);
                } else {
                    self.add(val.subSequence(0, this.limit));
                    this.limit = 0;
                    this.end();
                }
                return this;
            }

            @Override
            public AString add(char val) {
                if (this.limit == 0) {
                    this.end();
                    return this;
                }
                self.add(val);
                return this;
            }

            @Override
            public int length() {
                return self.length();
            }

            @Override
            public char charAt(int index) {
                return self.charAt(index);
            }

            @Override
            @NotNull
            public CharSequence subSequence(int start, int end) {
                return self.subSequence(start, end);
            }
        };
    }

    default public AString add(ToString val) {
        val.toString(this);
        return this;
    }

    public AString add(CharSequence var1);

    default public AString addSpace(int count) {
        if (count <= 0) {
            return this;
        }
        for (int i = 0; i < count; ++i) {
            this.add(' ');
        }
        return this;
    }

    default public AString repeat(int count, Object val) {
        for (int i = 0; i < count; ++i) {
            this.add(val);
        }
        return this;
    }

    default public AString repeat(int count, char val) {
        for (int i = 0; i < count; ++i) {
            this.add(val);
        }
        return this;
    }

    default public AString repeat(int count, String val) {
        for (int i = 0; i < count; ++i) {
            this.add(val);
        }
        return this;
    }

    default public int calcVisibleSymbols(int begin) {
        return this.calcVisibleSymbols(begin, this.length());
    }

    default public int calcVisibleSymbols(int begin, int end) {
        if (end > this.length()) {
            throw new IllegalStateException();
        }
        int i = 0;
        while (begin < end) {
            if (this.charAt(begin) == '\u001b') {
                while (begin < end && this.charAt(begin) != 'm') {
                    ++begin;
                }
            } else {
                ++i;
            }
            ++begin;
        }
        return i;
    }

    default public AString add(String val) {
        return this.add((CharSequence)val);
    }

    default public AString styleClear() {
        return this.add("\u001b[0m");
    }

    default public AString styleForeground(Style mode, int red, int green, int blue) {
        this.add("\u001b[");
        if (mode != null) {
            this.add(mode.ordinal()).add(";");
        }
        this.add("38;2;").add(red).add(";").add(green).add(";").add(blue).add("m");
        return this;
    }

    default public AString styleBackground(Style mode, int red, int green, int blue) {
        this.add("\u001b[");
        if (mode != null) {
            this.add(mode.ordinal()).add(";");
        }
        this.add("48;2;").add(red).add(";").add(green).add(";").add(blue).add("m");
        return this;
    }

    default public AString color(Color color) {
        this.add("\u001b[").add(color.code).add("m");
        return this;
    }

    default public AString style(Style mode, Color color) {
        if (color == null) {
            return this.style(mode);
        }
        this.add("\u001b[");
        if (mode != null) {
            this.add(mode.ordinal()).add(";");
        }
        this.add(color.code);
        this.add("m");
        return this;
    }

    default public AString style(Style mode) {
        this.add("\u001b[");
        this.add(mode.ordinal());
        this.add("m");
        return this;
    }

    default public AString add(char[] val) {
        if (val == null || val.length == 0) {
            return this;
        }
        this.add(val, 0, val.length);
        return this;
    }

    default public AString add(char[] val, int offset, int len) {
        return this.add(new CharSequenceByArray(val, offset, offset + len));
    }

    default public AString add(CharSequence val, int offset, int len) {
        return this.add(val.subSequence(offset, offset + len));
    }

    public AString add(char var1);

    default public AString add(boolean val) {
        this.add(Boolean.toString(val));
        return this;
    }

    default public AString add(int val) {
        this.add(Integer.toString(val));
        return this;
    }

    default public AString add(byte val) {
        this.add(Byte.toString(val));
        return this;
    }

    default public AString add(short val) {
        this.add(Short.toString(val));
        return this;
    }

    default public AString add(long val) {
        this.add(Long.toString(val));
        return this;
    }

    default public AString add(float val) {
        this.add(Float.toString(val));
        return this;
    }

    default public AString add(double val) {
        this.add(Double.toString(val));
        return this;
    }

    default public AString add(byte[] val) {
        HexUtils.toHexString(val, 0, val.length, this);
        return this;
    }

    default public AString add(Object[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (Object j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(", ");
                }
                this.add(j);
            }
        }
        return this;
    }

    default public AString add(int[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (int j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(',');
                }
                this.add(j);
            }
        }
        return this;
    }

    default public AString add(short[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (short j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(',');
                }
                this.add(j);
            }
        }
        return this;
    }

    default public AString add(long[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (long j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(',');
                }
                this.add(j);
            }
        }
        return this;
    }

    default public AString add(float[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (float j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(',');
                }
                this.add(j);
            }
        }
        return this;
    }

    default public AString add(double[] val) {
        if (val == null) {
            this.add("null");
        } else {
            boolean first = true;
            for (double j : val) {
                if (first) {
                    first = false;
                } else {
                    this.add(',');
                }
                this.add(j);
            }
        }
        return this;
    }

    default public <T> ABiConsumer<T, AString> getLocalRenderer(Class<T> cl) {
        return AString.getRenderer(cl);
    }

    default public AString addNull() {
        this.add("null");
        return this;
    }

    default public AString addStackTrace(Throwable e) {
        e.printStackTrace(this.toPrintWriter());
        return this;
    }

    default public AString add(Iterable<?> val) {
        if (val == null) {
            this.addNull();
            return this;
        }
        boolean first = true;
        for (Object e : val) {
            if (first) {
                first = false;
            } else {
                this.add(",");
            }
            this.add(e);
        }
        return this;
    }

    default public AString add(Object val) {
        if (val == null) {
            this.addNull();
            return this;
        }
        if (val instanceof Iterable) {
            return this.add((Iterable)val);
        }
        Class<?> cl = val.getClass();
        this.getLocalRenderer(cl).accept(RU.cast(val), this);
        return this;
    }

    default public int indexOf(CharSequence c) {
        return this.indexOf(c, 0);
    }

    default public int indexOf(CharSequence c, int offset) {
        if (c == null) {
            return -1;
        }
        int len = this.length() - c.length();
        block0: for (int i = offset; i <= len; ++i) {
            int ii = i;
            for (int i2 = 0; i2 < c.length(); ++i2) {
                if (this.charAt(ii++) != c.charAt(i2)) continue block0;
            }
            return i;
        }
        return -1;
    }

    default public PrintWriter toPrintWriter() {
        return new PrintWriter(new Writer(){

            @Override
            public void write(char @NotNull [] cbuf, int off, int len) throws IOException {
                AString.this.add(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
    }

    default public AString addVars(CharSequence msg, Object ... vars) {
        return this.addVars(msg, (CharSequence v) -> {
            for (int i = 0; i < vars.length; i += 2) {
                if (!Objects.equals(vars[i], v)) continue;
                return vars[i + 1];
            }
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    default public AString addVars(CharSequence msg, AFunction<CharSequence, Object> f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getStructuredStatement(GotoStatement.java:116)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public AString replaceAll(CharSequence src, char sample, String s) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c == sample) {
                this.add(s);
                continue;
            }
            this.add(c);
        }
        return this;
    }

    default public AString limitByteArrays(int max) {
        AString self = this;
        return new LimitByteArrays(self, max);
    }

    default public byte[] getBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    default public AString addWithAlign(int width, int firstIndent, int indent, String txt) {
        String[] text = txt.split(" ");
        int i = 0;
        int line = 0;
        this.addSpace(indent - firstIndent);
        while (i < text.length) {
            if (line + text[i].length() <= width || line == 0 && text[i].length() > width) {
                if (line > 0) {
                    this.add(" ");
                }
                this.add(text[i]);
                line += text[i].length();
            } else {
                line = 0;
                this.add("\n");
                this.addSpace(indent);
                continue;
            }
            ++i;
        }
        this.add("\n");
        return this;
    }

    public static <T> void putRenderer(Class<T> cl, ABiConsumer<T, AString> f) {
        renderers.put(cl, f);
    }

    public static AString of() {
        return AString.of(new StringBuilder());
    }

    public static AString of(StringBuilder stringBuilder) {
        return new Simple(stringBuilder);
    }

    public static <T> void addRenderer(Class<T> type, ABiConsumer<T, AString> renderer) {
        renderers.put(type, renderer);
    }

    public static <T> ABiConsumer<T, AString> getRenderer(Class<T> type) {
        if (type == null) {
            return (ABiConsumer)RU.cast(DEFAULT_RENDERER);
        }
        ABiConsumer<Object, AString> renderer = renderers.get(type);
        if (renderer != null) {
            return (ABiConsumer)RU.cast(renderer);
        }
        if (type.isArray()) {
            renderer = (v, s) -> s.add((Object[])v);
        } else {
            Class<?> i;
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            for (int j = 0; j < n && (renderer = AString.getRenderer(i = classArray[j])) == DEFAULT_RENDERER; ++j) {
            }
            if (renderer == DEFAULT_RENDERER) {
                renderer = AString.getRenderer(type.getSuperclass());
            }
        }
        if (renderer == null) {
            renderer = DEFAULT_RENDERER;
        }
        renderers.put(type, renderer);
        return (ABiConsumer)RU.cast(renderer);
    }

    public static class LimitByteArrays
    implements AString {
        private final AString self;
        private final int max;
        int cycleCounter;

        public LimitByteArrays(AString self, int max) {
            this.self = self;
            this.max = max;
        }

        @Override
        public AString add(CharSequence val) {
            this.self.add(val);
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return this.self.toString();
        }

        @Override
        public AString add(byte[] val) {
            if (val == null) {
                return this;
            }
            int l = Math.min(val.length, this.max);
            HexUtils.toHexString(val, 0, l, this);
            if (l != val.length) {
                this.add("...");
            }
            return this;
        }

        @Override
        public AString add(Object val) {
            ++this.cycleCounter;
            if (this.cycleCounter > 10) {
                throw new IllegalStateException();
            }
            try {
                if (val instanceof byte[]) {
                    AString aString = this.add((byte[])val);
                    return aString;
                }
                AString.super.add(val);
                LimitByteArrays limitByteArrays = this;
                return limitByteArrays;
            }
            finally {
                --this.cycleCounter;
            }
        }

        @Override
        public AString add(char val) {
            this.self.add(val);
            return this;
        }

        @Override
        public int length() {
            return this.self.length();
        }

        @Override
        public char charAt(int index) {
            return this.self.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return this.self.subSequence(start, end);
        }
    }

    public static class Simple
    implements AString {
        private final StringBuilder stringBuilder;

        public Simple(StringBuilder stringBuilder) {
            this.stringBuilder = stringBuilder;
        }

        @Override
        @NotNull
        public String toString() {
            return this.stringBuilder.toString();
        }

        @Override
        public AString add(char val) {
            this.stringBuilder.append(val);
            return this;
        }

        @Override
        public AString add(CharSequence val) {
            this.stringBuilder.append(val);
            return this;
        }

        @Override
        public AString add(char[] val, int offset, int len) {
            this.stringBuilder.append(val, offset, len);
            return this;
        }

        @Override
        public AString add(String val) {
            this.stringBuilder.append(val);
            return this;
        }

        @Override
        public AString add(char[] val) {
            this.stringBuilder.append(val);
            return this;
        }

        @Override
        public int length() {
            return this.stringBuilder.length();
        }

        @Override
        public char charAt(int index) {
            return this.stringBuilder.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return this.stringBuilder.subSequence(start, end);
        }
    }

    public static enum Style2 {
        UNDERSCORE_DOUBLE("21"),
        BORDER("51"),
        BORDER2("52"),
        UNDERSCORE2("53");

        public final String code;

        private Style2(String code) {
            this.code = code;
        }
    }

    public static enum BackgroundColor {
        BLACK("40"),
        RED("41"),
        GREEN("42"),
        ORANGE("43"),
        BLUE("44"),
        PURPLE("45"),
        CYAN("46"),
        WHITE("47");

        public final String code;

        private BackgroundColor(String code) {
            this.code = code;
        }
    }

    public static enum Color {
        BLACK("30"),
        RED("31"),
        GREEN("32"),
        ORANGE("33"),
        BLUE("34"),
        PURPLE("35"),
        CYAN("36"),
        WHITE("37");

        public final String code;

        private Color(String code) {
            this.code = code;
        }
    }

    public static enum Style {
        CLEAR,
        BRIGHT,
        DIM,
        ITALIC,
        UNDERSCORE,
        BLINK,
        UNKNOWN1,
        REVERSE,
        HIDDEN,
        UNKNOWN2,
        CROSSED;

    }
}

