/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.RU;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class ConcurrentPriorityQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    static final int MAXLEVEL = 10;
    static final double SLCONST = 0.5;
    static final Random RAND_GEN = new Random();
    private final Comparator<? super E> comparator;
    Node<E> head = new Node();
    Node<E> tail = new Node();

    public ConcurrentPriorityQueue() {
        for (int i = 0; i < 10; ++i) {
            this.head.next.add(new AtomicMarkableReference<Node<E>>(this.tail, false));
        }
        this.comparator = null;
    }

    public ConcurrentPriorityQueue(Comparator<? super E> cmp) {
        for (int i = 0; i < 10; ++i) {
            this.head.next.add(new AtomicMarkableReference<Node<E>>(this.tail, false));
        }
        this.comparator = cmp;
    }

    @Override
    public E remove() {
        E result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            try {
                itr.next();
            }
            catch (Exception e) {
                return size;
            }
            ++size;
        }
        return size;
    }

    @Override
    public E peek() {
        return this.head.next.get((int)0).getReference().data.getReference();
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.add(e);
    }

    public E peekFirst() {
        return this.head.next.get((int)0).getReference().data.getReference();
    }

    @Override
    public E poll() {
        return this.deleteMin();
    }

    @Override
    public boolean contains(Object o) {
        PQueueIterator itr = new PQueueIterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            if (!element.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.head.next.get(0).getReference() == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new PQueueIterator();
    }

    private int compare(E k1, E k2) {
        if (k1 == null && k2 == null) {
            return 0;
        }
        if (k1 == null) {
            return -1;
        }
        if (k2 == null) {
            return 1;
        }
        if (this.comparator == null) {
            return ((Comparable)RU.cast(k1)).compareTo(k2);
        }
        return this.comparator.compare(k1, k2);
    }

    private Node<E> readnode(Node<E> n, int ll) {
        if (n.next.get(ll).isMarked()) {
            return null;
        }
        return n.next.get(ll).getReference();
    }

    private NodePair<E> readNext(Node<E> n1, int ll) {
        Node<E> nn2;
        if (n1.data.isMarked()) {
            nn2 = this.helpDelete(n1, ll);
            n1 = nn2;
        }
        Node<E> n2 = this.readnode(n1, ll);
        while (n2 == null) {
            nn2 = this.helpDelete(n1, ll);
            n1 = nn2;
            n2 = this.readnode(n1, ll);
        }
        return new NodePair<E>(n1, n2);
    }

    private NodePair<E> scanKey(Node<E> n1, int ll, Node<E> nk) {
        NodePair<E> tn1 = this.readNext(n1, ll);
        n1 = tn1.n1;
        Node n2 = tn1.n2;
        while (this.compare(n2.data.getReference(), nk.data.getReference()) < 0 && n2 != this.tail) {
            n1 = n2;
            NodePair<E> tn2 = this.readNext(n1, ll);
            n1 = tn2.n1;
            n2 = tn2.n2;
        }
        return new NodePair<E>(n1, n2);
    }

    private Node<E> helpDelete(Node<E> n, int ll) {
        Node n2;
        int i = 0;
        for (i = ll; i <= n.validLevel - 1; ++i) {
            AtomicMarkableReference tempn1;
            while (!(tempn1 = n.next.get(i)).compareAndSet(n2 = tempn1.getReference(), n2, false, true) && !tempn1.isMarked()) {
            }
        }
        Node prev = n.prev;
        if (prev == null || ll >= prev.validLevel) {
            prev = this.head;
            for (i = 9; i >= ll; --i) {
                NodePair tn1 = this.scanKey(prev, i, n);
                n2 = tn1.n2;
                prev = tn1.n1;
            }
        }
        Node tmpN = n.next.get(ll).getReference();
        while (n.next.get(ll).getReference() != null) {
            NodePair tn2 = this.scanKey(prev, ll, n);
            Node last = tn2.n2;
            prev = tn2.n1;
            if (last != n || n.next.get(ll).getReference() == null) break;
            if (!tmpN.data.isMarked()) {
                if (prev.next.get(ll).compareAndSet(n, tmpN, false, false)) {
                    n.next.get(ll).set(null, true);
                    break;
                }
            } else {
                tmpN = tmpN.next.get(ll).getReference();
            }
            if (n.next.get(ll).getReference() != null) continue;
            break;
        }
        return prev;
    }

    private int randomLevel() {
        int v;
        for (v = 1; RAND_GEN.nextDouble() < 0.5 && v < 9; ++v) {
        }
        return v;
    }

    @Override
    public boolean add(E d) {
        Node n2;
        int i;
        ArrayList savedNode = new ArrayList();
        for (int ii = 0; ii < 10; ++ii) {
            savedNode.add(new Node());
        }
        int level = this.randomLevel();
        Node<E> newN = new Node<E>(level, d);
        Node n1 = this.head;
        for (i = 9; i >= 1; --i) {
            NodePair<E> tn1 = this.scanKey(n1, i, newN);
            n2 = tn1.n2;
            n1 = tn1.n1;
            if (i >= level) continue;
            savedNode.set(i, n1);
        }
        int kk = 0;
        while (true) {
            NodePair<E> tn2 = this.scanKey(n1, 0, newN);
            n2 = tn2.n2;
            n1 = tn2.n1;
            if (this.compare(d, n2.data.getReference()) == 0 && !n2.data.isMarked()) {
                if (!n2.data.compareAndSet(n2.data.getReference(), d, false, false)) continue;
                return true;
            }
            if (kk == 0) {
                newN.next.add(new AtomicMarkableReference(n2, false));
                ++kk;
                newN.validLevel = 0;
            } else {
                newN.next.set(0, new AtomicMarkableReference(n2, false));
            }
            if (n1.next.get(0).compareAndSet(n2, newN, false, false)) break;
        }
        for (i = 1; i <= level - 1; ++i) {
            newN.validLevel = i;
            n1 = (Node)savedNode.get(i);
            kk = 0;
            do {
                NodePair<E> tn3 = this.scanKey(n1, i, newN);
                n2 = tn3.n2;
                n1 = tn3.n1;
                if (kk == 0) {
                    newN.next.add(new AtomicMarkableReference(n2, false));
                    ++kk;
                    continue;
                }
                newN.next.set(i, new AtomicMarkableReference(n2, false));
            } while (!newN.data.isMarked() && !n1.next.get(i).compareAndSet(n2, newN, false, false));
        }
        newN.validLevel = level;
        if (newN.data.isMarked()) {
            newN = this.helpDelete(newN, 0);
        }
        return true;
    }

    private E deleteMin() {
        Object val;
        Node n1 = null;
        int i = 0;
        boolean iflag = false;
        Node<E> prev = this.head;
        while (true) {
            if (!iflag) {
                NodePair<E> tn1 = this.readNext(prev, 0);
                n1 = tn1.n2;
                prev = tn1.n1;
                if (n1 == this.tail) {
                    return null;
                }
            }
            iflag = false;
            val = n1.data.getReference();
            if (!n1.data.isMarked()) {
                if (n1.data.compareAndSet(n1.data.getReference(), n1.data.getReference(), false, true)) break;
                iflag = true;
                continue;
            }
            if (n1.data.isMarked()) {
                n1 = this.helpDelete(n1, 0);
            }
            prev = n1;
        }
        n1.prev = prev;
        for (i = 0; i <= n1.validLevel - 1; ++i) {
            Node n2;
            AtomicMarkableReference tempn1;
            while (!(tempn1 = n1.next.get(i)).compareAndSet(n2 = tempn1.getReference(), n2, false, true) && !tempn1.isMarked()) {
            }
        }
        prev = this.head;
        block3: for (i = n1.validLevel - 1; i >= 0; --i) {
            Node tmpN = n1.next.get(i).getReference();
            while (n1.next.get(i).getReference() != null) {
                NodePair<E> tn2 = this.scanKey(prev, i, n1);
                Node last = tn2.n2;
                prev = tn2.n1;
                if (last != n1 || n1.next.get(i).getReference() == null) continue block3;
                if (!tmpN.data.isMarked()) {
                    if (prev.next.get(i).compareAndSet(n1, tmpN, false, false)) {
                        n1.next.get(i).set(null, true);
                        continue block3;
                    }
                } else {
                    tmpN = tmpN.next.get(i).getReference();
                }
                if (n1.next.get(i).getReference() != null) continue;
            }
        }
        return val;
    }

    private class PQueueIterator
    implements Iterator<E> {
        Node<E> cursor;

        private PQueueIterator() {
            this.cursor = ConcurrentPriorityQueue.this.head.next.get(0).getReference();
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ConcurrentPriorityQueue.this.tail;
        }

        @Override
        public E next() {
            if (this.cursor == ConcurrentPriorityQueue.this.tail) {
                throw new NoSuchElementException();
            }
            Object result = this.cursor.data.getReference();
            this.cursor = this.cursor.next.get(0).getReference();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class NodePair<E> {
        Node<E> n1;
        Node<E> n2;

        public NodePair(Node<E> nn1, Node<E> nn2) {
            this.n1 = nn1;
            this.n2 = nn2;
        }
    }

    private static class Node<E> {
        int level;
        int validLevel;
        AtomicMarkableReference<E> data;
        Node<E> prev;
        ArrayList<AtomicMarkableReference<Node<E>>> next;
        E key;

        public Node() {
            this.data = new AtomicMarkableReference<Object>(null, false);
            this.prev = null;
            this.next = new ArrayList(10);
            this.key = null;
            this.validLevel = -1;
        }

        public Node(int l, E d) {
            this.data = new AtomicMarkableReference<E>(d, false);
            this.next = new ArrayList(10);
            this.level = l;
            this.key = d;
        }

        public Node(int l, E d, ArrayList<AtomicMarkableReference<Node<E>>> al) {
            this.level = l;
            this.key = d;
            this.data = new AtomicMarkableReference<E>(d, false);
            this.next = al;
        }

        public void setPrev(Node<E> p) {
            this.prev = p;
        }
    }
}

