/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

public class DataUtils {
    public static void writeByte(byte[] data, int offset, byte value) {
        data[offset] = value;
    }

    public static void writeShortLE(byte[] data, int offset, short value) {
        data[offset] = (byte)value;
        data[offset + 1] = (byte)(value >> 8);
    }

    public static void writeIntLE(byte[] data, int offset, int value) {
        data[offset] = (byte)value;
        data[offset + 1] = (byte)(value >> 8);
        data[offset + 2] = (byte)(value >> 16);
        data[offset + 3] = (byte)(value >> 24);
    }

    public static void writeLongLE(byte[] data, int offset, long value) {
        data[offset] = (byte)value;
        data[offset + 1] = (byte)(value >> 8);
        data[offset + 2] = (byte)(value >> 16);
        data[offset + 3] = (byte)(value >> 24);
        data[offset + 4] = (byte)(value >> 32);
        data[offset + 5] = (byte)(value >> 40);
        data[offset + 6] = (byte)(value >> 48);
        data[offset + 7] = (byte)(value >> 56);
    }

    public static void writeFloatLE(byte[] data, int offset, float value) {
        DataUtils.writeIntLE(data, offset, Float.floatToIntBits(value));
    }

    public static void writeDoubleLE(byte[] data, int offset, double value) {
        DataUtils.writeLongLE(data, offset, Double.doubleToLongBits(value));
    }

    public static void writeCharLE(byte[] data, int offset, char value) {
        DataUtils.writeShortLE(data, offset, (short)value);
    }

    public static byte readByte(byte[] data, int offset) {
        return data[offset];
    }

    public static short readShortLE(byte[] data, int offset) {
        return (short)(data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8);
    }

    public static int readIntLE(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    public static long readLongLE(byte[] data, int offset) {
        return (long)data[offset] & 0xFFL | ((long)data[offset + 1] & 0xFFL) << 8 | ((long)data[offset + 2] & 0xFFL) << 16 | ((long)data[offset + 3] & 0xFFL) << 24 | ((long)data[offset + 4] & 0xFFL) << 32 | ((long)data[offset + 5] & 0xFFL) << 40 | ((long)data[offset + 6] & 0xFFL) << 48 | ((long)data[offset + 7] & 0xFFL) << 56;
    }

    public static float readFloatLE(byte[] data, int offset) {
        return Float.intBitsToFloat(DataUtils.readIntLE(data, offset));
    }

    public static double readDoubleLE(byte[] data, int offset) {
        return Double.longBitsToDouble(DataUtils.readLongLE(data, offset));
    }

    public static char readCharLE(byte[] data, int offset) {
        return (char)DataUtils.readShortLE(data, offset);
    }
}

