/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.AString;
import java.util.Arrays;

public class HexUtils {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static byte[] hexToBytes(CharSequence s) {
        byte[] byteArray = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            int c1 = Arrays.binarySearch(HEX_ARRAY, s.charAt(i));
            int c2 = Arrays.binarySearch(HEX_ARRAY, s.charAt(i + 1));
            byteArray[i / 2] = (byte)(c1 << 4 | c2);
        }
        return byteArray;
    }

    public static String toHexString(byte[] bytes) {
        return new String(HexUtils.toHexString2(bytes));
    }

    public static char[] toHexString2(byte[] bytes) {
        return HexUtils.toHexString2(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int endIndex) {
        return new String(HexUtils.toHexString2(bytes, offset, endIndex));
    }

    public static char[] toHexString2(byte[] bytes, int offset, int endIndex) {
        if (bytes == null || bytes.length == 0) {
            return new char[0];
        }
        int len = endIndex - offset;
        char[] res = new char[len * 2];
        HexUtils.toHexString(bytes, offset, endIndex, res, 0);
        return res;
    }

    public static void toHexString(byte[] bytes, int offset, int endIndex, char[] hexChars, int destOffset) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int len = endIndex - offset;
        assert (hexChars.length - destOffset >= len * 2) : hexChars.length + "-" + destOffset + "<" + len + "*2==" + len * 2;
        for (int j = 0; j < len; ++j) {
            int v = bytes[j + offset] & 0xFF;
            hexChars[destOffset + j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[destOffset + j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
    }

    public static void toHexString(int src, AString hexChars) {
        hexChars.add(HEX_ARRAY[(src &= 0xFF) >>> 4]);
        hexChars.add(HEX_ARRAY[src & 0xF]);
    }

    public static void toHexString(long src, AString hexChars) {
        HexUtils.toHexString((int)src, hexChars);
    }

    public static void toHexString(byte[] bytes, int offset, int endIndex, AString hexChars) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int len = endIndex - offset;
        for (int j = 0; j < len; ++j) {
            int v = bytes[j + offset] & 0xFF;
            HexUtils.toHexString(v, hexChars);
        }
    }

    public static void toHexString(int bytes, char[] hexChars, int destOffset) {
        int len = 4;
        assert (hexChars.length - destOffset >= 8);
        for (int j = 0; j < 4; ++j) {
            int v = bytes >> 8 * j & 0xFF;
            hexChars[destOffset + j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[destOffset + j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
    }

    public static void toHexString(long bytes, char[] hexChars, int destOffset) {
        int len = 8;
        assert (hexChars.length - destOffset >= 16);
        for (int j = 0; j < 8; ++j) {
            int v = (int)(bytes >> 8 * j & 0xFFL);
            hexChars[destOffset + j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[destOffset + j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
    }
}

