/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ModuleAutoRun {
    private static final String AUTO_RUN_FILE_EXTENSION = ".autorun";
    private static final String DUMMY_RESOURCE_NAME = "io/aether/utils/ModuleAutoRun.class";

    private static Set<URL> scanJarForAutorunFiles(String extension) {
        HashSet<URL> resultUrls = new HashSet<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL classUrl = classLoader.getResource(DUMMY_RESOURCE_NAME);
        if (classUrl != null && "jar".equals(classUrl.getProtocol())) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)classUrl.openConnection();
                JarFile jarFile = jarConnection.getJarFile();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    URL entryUrl;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(extension) || name.indexOf(47) != -1 || (entryUrl = classLoader.getResource(name)) == null) continue;
                    resultUrls.add(entryUrl);
                }
            }
            catch (Exception e) {
                Log.warn("Failed to scan the running JAR for resources.", e, new Object[0]);
            }
        }
        return resultUrls;
    }

    private static Set<URL> scanClassPathForAutorunFiles(String extension) {
        HashSet<URL> resultUrls = new HashSet<URL>();
        try {
            String[] pathElements;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String classpath = System.getProperty("java.class.path");
            for (String element : pathElements = classpath.split(System.getProperty("path.separator"))) {
                File[] files;
                File elementFile = new File(element);
                if (!elementFile.exists()) continue;
                if (element.toLowerCase().endsWith(".jar")) {
                    try (JarFile jar = new JarFile(elementFile);){
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            URL entryUrl;
                            JarEntry entry = entries.nextElement();
                            String name2 = entry.getName();
                            if (!name2.endsWith(extension) || name2.indexOf(47) != -1 || (entryUrl = classLoader.getResource(name2)) == null) continue;
                            resultUrls.add(entryUrl);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("Failed to scan JAR file: " + element, e, new Object[0]);
                    }
                    continue;
                }
                if (!elementFile.isDirectory() || (files = elementFile.listFiles((dir, name) -> name.toLowerCase().endsWith(extension))) == null) continue;
                for (File file : files) {
                    URL fileUrl = classLoader.getResource(file.getName());
                    if (fileUrl == null) continue;
                    resultUrls.add(fileUrl);
                }
            }
        }
        catch (Exception e) {
            Log.error("Error during full classpath scan for extension: " + extension, e, new Object[0]);
            return Collections.emptySet();
        }
        return resultUrls;
    }

    public static void initialize(String moduleName) {
    }

    static {
        HashSet<URL> autorunUrls = new HashSet<URL>();
        try {
            autorunUrls.addAll(ModuleAutoRun.scanJarForAutorunFiles(AUTO_RUN_FILE_EXTENSION));
        }
        catch (Exception e) {
            Log.error("Error during JAR-based classpath scan.", e, new Object[0]);
        }
        if (autorunUrls.isEmpty()) {
            try {
                autorunUrls.addAll(ModuleAutoRun.scanClassPathForAutorunFiles(AUTO_RUN_FILE_EXTENSION));
            }
            catch (Exception e) {
                Log.error("Error during java.class.path fallback scan.", e, new Object[0]);
            }
        }
        Log.info("Found " + autorunUrls.size() + " module autorun resources.", new LNode[0]);
        for (URL resourceUrl : autorunUrls) {
            String className = null;
            try {
                InputStream inputStream = resourceUrl.openStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    className = reader.readLine();
                    if (className == null || className.trim().isEmpty()) continue;
                    className = className.trim();
                    Log.info("Initializing auto-run module: " + className + " from " + String.valueOf(resourceUrl), new LNode[0]);
                    Class.forName(className);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                Log.error("Failed to load autorun class " + className + " from " + String.valueOf(resourceUrl), e, new Object[0]);
            }
        }
    }
}

