/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.slots.EventConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;

public class QueueWithEvents<T>
implements Queue<T> {
    public final EventConsumer<QueueWithEvents<T>> onAdd = new EventConsumer();
    private final Queue<T> target;

    public QueueWithEvents() {
        this(new ConcurrentLinkedQueue());
    }

    public QueueWithEvents(Queue<T> target) {
        this.target = target;
    }

    @Override
    public boolean add(T t) {
        boolean result = this.target.add(t);
        if (result) {
            this.onAdd.fire(this);
        }
        return result;
    }

    @Override
    public boolean offer(T t) {
        boolean result = this.target.offer(t);
        if (result) {
            this.onAdd.fire(this);
        }
        return result;
    }

    @Override
    public T remove() {
        return this.target.remove();
    }

    @Override
    public T poll() {
        return this.target.poll();
    }

    @Override
    public T element() {
        return this.target.element();
    }

    @Override
    public T peek() {
        return this.target.peek();
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.target.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.target.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.target.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.target.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.target.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean result = this.target.addAll(c);
        if (result) {
            this.onAdd.fire(this);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.target.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.target.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.target.retainAll(c);
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    public Queue<T> getTargetQueue() {
        return this.target;
    }

    public boolean hasListeners() {
        return this.onAdd.hasListener();
    }
}

