/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.logger.Log;
import io.aether.utils.RU;
import io.aether.utils.interfaces.AFunction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Settings {
    private static final Map<String, Object> data;

    public static String getr(String key) {
        String val = Settings.getString(key);
        if (val == null) {
            throw new IllegalStateException("Key is not found: " + key);
        }
        return val;
    }

    public static boolean check(String key, Object value) {
        String v = Settings.getString(key);
        if (v == null) {
            return false;
        }
        String v2 = String.valueOf(value);
        return v.equalsIgnoreCase(v2);
    }

    public static <T> T parse(String key, AFunction<String, T> converter) {
        String r = Settings.getString(key);
        if (r == null) {
            return null;
        }
        return converter.apply(r);
    }

    public static String getString(String key) {
        Object val = data.get(key);
        if (val != null) {
            return String.valueOf(val);
        }
        val = System.getProperty(key);
        if (val != null) {
            return String.valueOf(val);
        }
        val = System.getenv().get(key);
        return val == null ? null : String.valueOf(val);
    }

    public static <T> T get(String key) {
        Object val = data.get(key);
        if (val != null) {
            return RU.cast(val);
        }
        val = System.getProperty(key);
        if (val != null) {
            return RU.cast(val);
        }
        val = System.getenv().get(key);
        return RU.cast(val);
    }

    public static void set(String key, Object value) {
        data.put(key, value);
    }

    private static void loadFile(File f) {
        if (!f.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = br.readLine()) != null) {
                String value;
                int i = line.indexOf("=");
                String key = line.substring(0, i);
                Object old = data.put(key, value = line.substring(i + 1));
                if (old == null) continue;
                Log.warn("Already setting [$key]: new($value), old($oldValue)", "key", key, "value", value, "oldValue", old);
            }
        }
        catch (IOException e) {
            RU.error(e);
        }
    }

    public static int getString(String key, int def) {
        try {
            String val = Settings.getString(key);
            if (val == null) {
                return def;
            }
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return def;
        }
    }

    static {
        String[] classpathEntries;
        data = new ConcurrentHashMap<String, Object>();
        String classpath = System.getProperty("java.class.path");
        for (String s : classpathEntries = classpath.split(File.pathSeparator)) {
            File f = new File(s);
            Settings.loadFile(new File(f, "aether.config"));
        }
    }
}

