/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class WeakCollection<T>
implements Iterable<T> {
    private final ConcurrentLinkedQueue<WeakReference<T>> q = new ConcurrentLinkedQueue();

    public int size() {
        return this.q.size();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (WeakReference<T> e : this.q) {
            Object v = e.get();
            if (v == null) continue;
            action.accept(v);
        }
    }

    public Object add(T entry) {
        WeakReference<T> res = new WeakReference<T>(entry);
        this.q.add(res);
        return res;
    }

    public void remove(Object key) {
        this.q.removeIf(v -> {
            Object vv = v.get();
            return vv == null || vv == key;
        });
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        final Iterator<WeakReference<T>> t = this.q.iterator();
        return new Iterator<T>(){
            T val;

            @Override
            public boolean hasNext() {
                while (this.val == null && t.hasNext()) {
                    this.val = ((WeakReference)t.next()).get();
                }
                return this.val != null;
            }

            @Override
            public T next() {
                Object res = this.val;
                this.val = null;
                return res;
            }
        };
    }
}

