/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.RU;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;

public class WeakConcurrentHashMap<K, V>
implements ConcurrentMap<K, V> {
    private static final List<MapTracker> ALL_TRACKERS = new CopyOnWriteArrayList<MapTracker>();
    private static final ReferenceQueue<WeakConcurrentHashMap<?, ?>> TRACKER_QUEUE = new ReferenceQueue();
    private static final ScheduledFuture<?> CLEANER_TASK = RU.scheduleAtFixedRate(1000L, () -> {
        MapTracker tracker;
        for (MapTracker tracker2 : ALL_TRACKERS) {
            WeakConcurrentHashMap map = (WeakConcurrentHashMap)tracker2.get();
            if (map == null) continue;
            map.flushMem();
        }
        while ((tracker = (MapTracker)TRACKER_QUEUE.poll()) != null) {
            ALL_TRACKERS.remove(tracker);
        }
    });
    private final ConcurrentMap<WeakKey<K>, V> body;
    private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();

    public WeakConcurrentHashMap() {
        this.body = new ConcurrentHashMap<WeakKey<K>, V>();
        ALL_TRACKERS.add(new MapTracker(this, this.referenceQueue));
    }

    private void flushMem() {
        WeakKey weakKey;
        while ((weakKey = (WeakKey)RU.cast(this.referenceQueue.poll())) != null) {
            this.body.remove(weakKey);
        }
    }

    private WeakKey<K> makeSampleKey(Object key) {
        return new WeakKey(key);
    }

    @Override
    public V put(@NotNull K key, V value) {
        return this.body.put(new WeakKey<K>(key, this.referenceQueue), value);
    }

    @Override
    public V get(Object key) {
        return this.body.get(this.makeSampleKey(key));
    }

    @Override
    public V remove(Object key) {
        return this.body.remove(this.makeSampleKey(key));
    }

    @Override
    public int size() {
        return this.body.size();
    }

    @Override
    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.body.containsKey(this.makeSampleKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.body.containsValue(value);
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        return this.body.putIfAbsent(new WeakKey<K>(key, this.referenceQueue), value);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        return this.body.remove(this.makeSampleKey(key), value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        return this.body.replace(new WeakKey<K>(key, this.referenceQueue), oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        return this.body.replace(new WeakKey<K>(key, this.referenceQueue), value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.body.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public int size() {
                return WeakConcurrentHashMap.this.body.size();
            }

            @Override
            public boolean contains(Object o) {
                return WeakConcurrentHashMap.this.containsKey(o);
            }

            @Override
            @NotNull
            public Iterator<K> iterator() {
                final Iterator it = WeakConcurrentHashMap.this.body.keySet().iterator();
                return new Iterator<K>(){
                    K nextKey = null;

                    @Override
                    public boolean hasNext() {
                        if (this.nextKey != null) {
                            return true;
                        }
                        while (it.hasNext()) {
                            WeakKey weakKey = (WeakKey)it.next();
                            Object k = weakKey.get();
                            if (k == null) continue;
                            this.nextKey = k;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object k = this.nextKey;
                        this.nextKey = null;
                        return k;
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.body.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return WeakConcurrentHashMap.this.body.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object value = WeakConcurrentHashMap.this.get(e.getKey());
                return Objects.equals(value, e.getValue());
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = WeakConcurrentHashMap.this.body.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> nextEntry = null;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry != null) {
                            return true;
                        }
                        while (it.hasNext()) {
                            Map.Entry entry = (Map.Entry)it.next();
                            Object k = ((WeakKey)entry.getKey()).get();
                            if (k == null) continue;
                            this.nextEntry = new SimpleEntry(k, entry.getValue());
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Map.Entry e = this.nextEntry;
                        this.nextEntry = null;
                        return e;
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }
        };
    }

    public static void shutdownGlobalCleaner() {
        if (CLEANER_TASK != null && !CLEANER_TASK.isDone()) {
            CLEANER_TASK.cancel(true);
        }
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K> {
        final int hash;
        final Object identity;

        public WeakKey(K referent, ReferenceQueue<K> q) {
            super(referent, q);
            this.hash = referent.hashCode();
            this.identity = referent;
        }

        public WeakKey(Object referent) {
            super(null, null);
            this.hash = referent.hashCode();
            this.identity = referent;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WeakKey)) {
                return false;
            }
            WeakKey other = (WeakKey)obj;
            if (this.hash != other.hash) {
                return false;
            }
            Object t = this.get();
            Object o = other.get();
            if (o == null && other.identity != null) {
                o = other.identity;
            }
            if (t != null && o != null) {
                return t.equals(o);
            }
            return false;
        }
    }

    private static final class MapTracker
    extends WeakReference<WeakConcurrentHashMap<?, ?>> {
        final ReferenceQueue<?> mapRefQueue;

        MapTracker(WeakConcurrentHashMap<?, ?> map, ReferenceQueue<?> q) {
            super(map, TRACKER_QUEUE);
            this.mapRefQueue = map.referenceQueue;
        }
    }
}

