/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakIdenticalConcurrentHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final Map<MaskI<K>, MaskI<V>> body = new ConcurrentHashMap<MaskI<K>, MaskI<V>>();
    private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        return (V)WeakIdenticalConcurrentHashMap.unmask((MaskI)this.body.putIfAbsent(new MaskSample<K>(key), new MaskSample<V>(value)));
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        return this.body.remove(new MaskSample<Object>(key), new MaskSample<Object>(value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        return this.body.replace(new MaskSample<K>(key), new MaskSample<V>(oldValue), new Mask<V>(newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        return (V)WeakIdenticalConcurrentHashMap.unmask((MaskI)this.body.replace(new MaskSample<K>(key), new Mask<V>(value)));
    }

    @Override
    public int size() {
        return this.body.size();
    }

    @Override
    public boolean isEmpty() {
        return this.body.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.body.containsKey(new MaskSample<Object>(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.body.containsValue(new MaskSample<Object>(value));
    }

    @Override
    public V get(Object key) {
        return WeakIdenticalConcurrentHashMap.unmask(this.body.get(new MaskSample<Object>(key)));
    }

    private void flushMem() {
        Mask v;
        while ((v = (Mask)RU.cast(this.referenceQueue.poll())) != null) {
            this.body.remove(v);
        }
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.flushMem();
        return (V)WeakIdenticalConcurrentHashMap.unmask((MaskI)this.body.put(new Mask<K>(key, this.referenceQueue), new Mask<V>(value)));
    }

    @Override
    public V remove(Object key) {
        return WeakIdenticalConcurrentHashMap.unmask(this.body.remove(new MaskSample<Object>(key)));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.body.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new Set<K>(){

            @Override
            public int size() {
                return WeakIdenticalConcurrentHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return WeakIdenticalConcurrentHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return WeakIdenticalConcurrentHashMap.this.containsKey(o);
            }

            @Override
            @NotNull
            public Iterator<K> iterator() {
                final Iterator it = WeakIdenticalConcurrentHashMap.this.body.keySet().iterator();
                return new Iterator<K>(){
                    K last;

                    @Override
                    public boolean hasNext() {
                        while (this.last == null && it.hasNext()) {
                            this.last = ((MaskI)it.next()).get();
                        }
                        return this.last != null;
                    }

                    @Override
                    public K next() {
                        Object k = this.last;
                        this.last = null;
                        return k;
                    }
                };
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return Flow.flow(this.iterator()).toArray();
            }

            @Override
            @NotNull
            public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                return Flow.flow(this.iterator()).toList().toArray(a);
            }

            @Override
            public boolean add(K k) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                return WeakIdenticalConcurrentHashMap.this.remove(new MaskSample<Object>(o)) != null;
            }

            @Override
            public boolean containsAll(@NotNull Collection<?> c) {
                for (Object v : c) {
                    if (this.contains(v)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends K> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> c) {
                boolean res = true;
                for (Object e : c) {
                    res &= this.remove(e);
                }
                return res;
            }

            @Override
            public void clear() {
                WeakIdenticalConcurrentHashMap.this.body.clear();
            }
        };
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return Flow.flow(this.entrySet()).map(Map.Entry::getValue).toList();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return WeakIdenticalConcurrentHashMap.this.body.size();
            }

            @Override
            public boolean isEmpty() {
                return WeakIdenticalConcurrentHashMap.this.body.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return WeakIdenticalConcurrentHashMap.this.containsKey(((Map.Entry)o).getKey());
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = WeakIdenticalConcurrentHashMap.this.body.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){
                    Map.Entry<K, V> last;

                    @Override
                    public boolean hasNext() {
                        while (this.last == null && it.hasNext()) {
                            final Map.Entry e = (Map.Entry)it.next();
                            final Object k = ((MaskI)e.getKey()).get();
                            if (k == null) continue;
                            this.last = new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return k;
                                }

                                @Override
                                public V getValue() {
                                    return WeakIdenticalConcurrentHashMap.unmask((MaskI)e.getValue());
                                }

                                @Override
                                public V setValue(V value) {
                                    return WeakIdenticalConcurrentHashMap.unmask(e.setValue(new Mask(value)));
                                }
                            };
                        }
                        return this.last != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry l = this.last;
                        this.last = null;
                        return l;
                    }
                };
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return Flow.flow(this.iterator()).toArray();
            }

            @Override
            @NotNull
            public <T> @NotNull T @NotNull [] toArray(@NotNull @NotNull T @NotNull [] a) {
                return Flow.flow(this.iterator()).toList().toArray(a);
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                return !Objects.equals(WeakIdenticalConcurrentHashMap.this.put(entry.getKey(), entry.getValue()), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)RU.cast(o);
                return WeakIdenticalConcurrentHashMap.this.remove(e.getKey(), e.getValue());
            }

            @Override
            public boolean containsAll(@NotNull Collection<?> c) {
                for (Object e : c) {
                    if (this.contains(e)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(@NotNull Collection<? extends Map.Entry<K, V>> c) {
                boolean res = true;
                for (Map.Entry e : c) {
                    res &= this.add(e);
                }
                return res;
            }

            @Override
            public boolean retainAll(@NotNull Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(@NotNull Collection<?> c) {
                boolean res = true;
                for (Object e : c) {
                    res &= this.remove(e);
                }
                return res;
            }

            @Override
            public void clear() {
                WeakIdenticalConcurrentHashMap.this.body.clear();
            }
        };
    }

    private static <E> E unmask(MaskI<E> r) {
        if (r == null) {
            return null;
        }
        return r.get();
    }

    private static class Mask<K>
    extends WeakReference<K>
    implements MaskI<K> {
        final int hash;

        public Mask(K referent, ReferenceQueue<K> referenceQueue) {
            super(referent, referenceQueue);
            this.hash = referent.hashCode();
        }

        public Mask(K referent) {
            super(referent);
            this.hash = referent.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Mask k = (Mask)RU.cast(obj);
            return this.get() == k.get();
        }
    }

    private static class MaskSample<K>
    implements MaskI<K> {
        K val;
        int hash;

        public MaskSample(K val) {
            this.hash = val.hashCode();
            this.val = val;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Mask k = (Mask)RU.cast(obj);
            return this.get() == k.get();
        }

        @Override
        public K get() {
            return this.val;
        }
    }

    private static interface MaskI<K> {
        public K get();
    }
}

