/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dataio;

import io.aether.utils.dataio.DataIO;
import io.aether.utils.dataio.DataInOutStatic;

public interface DataIn {
    public int getSizeForRead();

    default public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    default public int read(int[] b) {
        return this.read(b, 0, b.length);
    }

    default public int read(byte[] b, int offset, int len) {
        int endIndex = Math.min(offset + len, b.length);
        for (int i = offset; i < endIndex; ++i) {
            b[i] = this.readByte();
        }
        return endIndex - offset;
    }

    default public int read(int[] b, int offset, int len) {
        int endIndex = Math.min(offset + len, b.length);
        for (int i = offset; i < endIndex; ++i) {
            b[i] = this.readInt();
        }
        return endIndex - offset;
    }

    default public boolean isEmpty() {
        return this.getSizeForRead() == 0;
    }

    default public void skipBytes(int n) {
        for (int i = 0; i < n; ++i) {
            this.readUByte();
        }
    }

    default public boolean isReadable() {
        return this.getSizeForRead() != 0;
    }

    default public boolean readBoolean() {
        return this.readUByte() != 0;
    }

    default public byte readByte() {
        return (byte)this.readUByte();
    }

    public int readUByte();

    default public DataIO readSubData(int length) {
        DataInOutStatic res = new DataInOutStatic(length);
        this.read(res.data);
        return res;
    }

    default public short readShort() {
        return (short)this.readUShort();
    }

    default public int readUShort() {
        int res = 0;
        for (int i = 0; i < 2; ++i) {
            res |= (this.readUByte() & 0xFF) << 8 * i;
        }
        return res;
    }

    default public char readChar() {
        return (char)this.readUByte();
    }

    default public int readInt() {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res |= this.readUByte() << 8 * i;
        }
        return res;
    }

    default public long readUInt() {
        long res = 0L;
        for (int i = 0; i < 4; ++i) {
            res |= (long)this.readUByte() << 8 * i;
        }
        return res;
    }

    default public long readLong() {
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res |= (long)this.readUByte() << 8 * i;
        }
        return res;
    }

    default public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    default public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    default public String readString1() {
        int len = this.readUByte();
        byte[] data = new byte[len];
        this.read(data);
        return new String(data);
    }

    default public byte[] toArray() {
        byte[] d = new byte[this.getSizeForRead()];
        this.read(d);
        return d;
    }

    default public void skipAllBytes() {
        for (int i = 0; i < this.getSizeForRead(); ++i) {
            this.readUByte();
        }
    }

    public int indexOf(int var1, byte var2);

    default public byte[] readBytes(int len) {
        byte[] res = new byte[len];
        this.read(res);
        return res;
    }
}

