/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.dataio;

import io.aether.utils.HexUtils;
import io.aether.utils.dataio.DataIO;
import io.aether.utils.dataio.DataIn;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DataInOut
implements DataIO {
    public byte[] data;
    public int writePos;
    public int readPos;

    public DataInOut(byte[] data, int len) {
        this.data = data;
        this.writePos = len;
    }

    @Override
    public byte[] toArray() {
        if (this.data.length == this.getSizeForRead()) {
            byte[] d = this.data;
            this.data = new byte[d.length];
            this.clear();
            return d;
        }
        byte[] r = Arrays.copyOfRange(this.data, this.readPos, this.writePos);
        this.clear();
        return r;
    }

    public DataInOut() {
        this(100);
    }

    public DataInOut(int initSize) {
        this.data = new byte[initSize];
    }

    public DataInOut(byte[] data) {
        this.data = data;
        this.writePos = data.length;
    }

    public String toString() {
        return HexUtils.toHexString(this.data, this.readPos, this.writePos);
    }

    @Override
    public void write(DataIn data) {
        int needEnd = this.writePos + data.getSizeForRead();
        if (needEnd >= this.data.length) {
            this.data = Arrays.copyOf(this.data, needEnd * 2);
        }
        data.read(this.data, this.writePos, data.getSizeForRead());
        this.writePos = needEnd;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.writePos = data.length;
        this.readPos = 0;
    }

    public int getWritePos() {
        return this.writePos;
    }

    public void setWritePos(int writePos) {
        this.writePos = writePos;
    }

    public int getReadPos() {
        return this.readPos;
    }

    public void setReadPos(int readPos) {
        this.readPos = readPos;
    }

    @Override
    public void clear() {
        this.writePos = 0;
        this.readPos = 0;
    }

    @Override
    public int readInt() {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            res |= this.readUByte0() << 8 * i;
        }
        this.trim();
        return res;
    }

    @Override
    public long readLong() {
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res |= (long)this.readUByte0() << 8 * i;
        }
        this.trim();
        return res;
    }

    @Override
    public int readUShort() {
        int res = 0;
        for (int i = 0; i < 2; ++i) {
            res |= (this.readUByte0() & 0xFF) << 8 * i;
        }
        this.trim();
        return res;
    }

    public byte[] toArrayCopy() {
        return Arrays.copyOfRange(this.data, this.readPos, this.writePos);
    }

    @Override
    public int getSizeForRead() {
        return this.writePos - this.readPos;
    }

    @Override
    public int read(byte[] b, int offset, int len) {
        int a = this.getSizeForRead();
        int l = Math.min(Math.min(len, b.length), a);
        if (l > 0) {
            System.arraycopy(this.data, this.readPos, b, offset, l);
            this.readPos += l;
        }
        this.trim();
        return l;
    }

    public void trim() {
        if (this.writePos == this.readPos) {
            this.writePos = 0;
            this.readPos = 0;
        }
    }

    private int readUByte0() {
        return Byte.toUnsignedInt(this.data[this.readPos++]);
    }

    @Override
    public void skipAllBytes() {
        this.writePos = 0;
        this.readPos = 0;
    }

    @Override
    public int indexOf(int limit, byte val) {
        for (int i = this.readPos; i < this.writePos; ++i) {
            if (this.data[i] != val) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void skipBytes(int n) {
        this.readPos += n;
        assert (this.readPos <= this.writePos);
        this.trim();
    }

    @Override
    public void write(byte @NotNull [] b) {
        this.checkSize(b.length);
        System.arraycopy(b, 0, this.data, this.writePos, b.length);
        this.writePos += b.length;
    }

    @Override
    public int write(byte @NotNull [] b, int off, int len) {
        this.checkSize(len);
        System.arraycopy(b, off, this.data, this.writePos, len);
        this.writePos += len;
        return len;
    }

    @Override
    public int readUByte() {
        assert (this.readPos < this.writePos);
        int res = this.readUByte0();
        this.trim();
        return res;
    }

    @Override
    public void writeByte(int v) {
        if (this.writePos >= this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.writePos++] = (byte)v;
    }

    public void checkSize(int size) {
        if (this.data.length - this.writePos < size) {
            this.data = Arrays.copyOf(this.data, (int)((double)(this.writePos + size) * 1.3));
        }
    }
}

