/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.flow;

import io.aether.utils.flow.Flow;
import io.aether.utils.flow.FlowByte;
import io.aether.utils.flow.FlowCompleted;
import io.aether.utils.interfaces.AFunctionB2O;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface FlowCompletedByte
extends FlowByte {
    public int count();

    @Override
    @NotNull
    default public ByteList toList() {
        ByteArrayList res = new ByteArrayList(this.count());
        while (this.hasNext()) {
            res.add(this.nextByte());
        }
        return res;
    }

    @Override
    default public Flow<Byte> box() {
        final FlowCompletedByte self = this;
        return new FlowCompleted<Byte>(){

            @Override
            public int count() {
                return self.count();
            }

            @Override
            public boolean hasNext() {
                return self.hasNext();
            }

            @Override
            public Byte next() {
                return self.nextByte();
            }
        };
    }

    @Override
    @NotNull
    default public <K, V> Map<K, V> toMap(AFunctionB2O<K> keyFactory, AFunctionB2O<V> valFactory) {
        Object2ObjectOpenHashMap res = new Object2ObjectOpenHashMap(this.count());
        while (this.hasNext()) {
            byte val = this.nextByte();
            res.put(keyFactory.apply(val), valFactory.apply(val));
        }
        return res;
    }

    @Override
    default public byte @NotNull [] toArray() {
        byte[] res = new byte[this.count()];
        int i = 0;
        while (this.hasNext()) {
            res[i++] = this.nextByte();
        }
        return res;
    }
}

