/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.futures;

import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.AFutureBase;
import io.aether.utils.futures.ARFutureImpl;
import io.aether.utils.futures.ARFutureWithFlag;
import io.aether.utils.interfaces.A2Function;
import io.aether.utils.interfaces.A3Consumer;
import io.aether.utils.interfaces.A3Function;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.ACallable;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.ARunnable;
import io.aether.utils.tuples.Tuple2;
import io.aether.utils.tuples.Tuple3;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public interface ARFuture<T>
extends AFutureBase<ARFuture<T>> {
    public static final ARFuture<Boolean> TRUE = ARFuture.of(true);
    public static final ARFuture<Boolean> FALSE = ARFuture.of(false);

    public ARFutureWithFlag<T> toWithFlag();

    public void done(T var1);

    public boolean tryDone(T var1);

    public T get();

    public T get(long var1);

    public T getNow();

    public T getNowElse(T var1);

    public ARFuture<T> to(AConsumer<T> var1);

    public ARFuture<T> to(AConsumer<T> var1, AConsumer<Throwable> var2);

    public ARFuture<T> to(@NotNull AConsumer<T> var1, int var2, ARunnable var3);

    public ARFuture<T> to(@NotNull ARFuture<T> var1);

    public ARFuture<T> to(@NotNull AFuture var1);

    public AFuture toFuture();

    public <T2> ARFuture<Tuple2<T, T2>> and(ARFuture<T2> var1);

    @NotNull
    public <E> ARFuture<E> map(@NotNull AFunction<T, E> var1);

    @NotNull
    public <E> ARFuture<E> mapWL(@NotNull AFunction<T, E> var1);

    @NotNull
    public <E> ARFuture<E> mapRFuture(@NotNull AFunction<T, ARFuture<E>> var1);

    @NotNull
    public AFuture mapToFuture(@NotNull AConsumer<T> var1);

    public <E> ARFuture<E> mapSafe(@NotNull AFunction<T, E> var1);

    public ARFuture<T> apply(ARunnable var1);

    public ARFuture<T> apply(AConsumer<T> var1);

    public static <T> ARFuture<T> of(T value) {
        return ARFutureImpl.of(value);
    }

    public static <T> ARFuture<T> canceled() {
        return ARFutureImpl.canceled();
    }

    public static <T> ARFuture<T> ofThrow(Throwable throwable) {
        return ARFutureImpl.ofThrow(throwable);
    }

    public static <T> ARFuture<T> run2(Executor executor, ACallable<ARFuture<T>> task) {
        return ARFutureImpl.run2(executor, task);
    }

    public static <T> ARFuture<T> run(Executor executor, ACallable<T> task) {
        return ARFutureImpl.run(executor, task);
    }

    public static <T> ARFuture<T> anyAndCancel(Flow<ARFuture<T>> ff) {
        return ARFutureImpl.anyAndCancel(ff);
    }

    public static <T> ARFuture<T> any(Collection<ARFuture<T>> ff) {
        return ARFutureImpl.any(ff);
    }

    public static <T> ARFuture<T[]> all(Class<T> elType, Flow<ARFuture<T>> ff) {
        return ARFutureImpl.all(elType, ff);
    }

    @SafeVarargs
    public static <T> ARFuture<T[]> all(Class<T> elType, ARFuture<T> ... ff) {
        return ARFutureImpl.all(elType, ff);
    }

    public static <T1, T2> ARFuture<Tuple2<T1, T2>> all(ARFuture<T1> f1, ARFuture<T2> f2) {
        return ARFutureImpl.all(f1, f2);
    }

    public static <T1, T2, T3> ARFuture<Tuple3<T1, T2, T3>> all(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3) {
        return ARFutureImpl.all(f1, f2, f3);
    }

    public static <T> ARFuture<List<T>> all(@NotNull List<ARFuture<T>> list) {
        return ARFutureImpl.all(list);
    }

    public static <T1, T2> ARFuture<Tuple2<T1, T2>> all(ARFuture<T1> f1, ARFuture<T2> f2, ABiConsumer<T1, T2> task) {
        return ARFutureImpl.all(f1, f2, task);
    }

    public static <T1, T2, T3> ARFuture<Tuple3<T1, T2, T3>> all(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3, A3Consumer<T1, T2, T3> task) {
        return ARFutureImpl.all(f1, f2, f3, task);
    }

    public static <T1, T2, R> ARFuture<R> map(ARFuture<T1> f1, ARFuture<T2> f2, A2Function<T1, T2, R> task) {
        return ARFutureImpl.map(f1, f2, task);
    }

    public static <T1, T2, T3, R> ARFuture<R> map(ARFuture<T1> f1, ARFuture<T2> f2, ARFuture<T3> f3, A3Function<T1, T2, T3, R> task) {
        return ARFutureImpl.map(f1, f2, f3, task);
    }

    public static <T> ARFuture<T> make() {
        return new ARFutureImpl();
    }

    public static <T> ARFuture<T> doThrow(Throwable e) {
        ARFutureImpl res = new ARFutureImpl();
        res.setError(e);
        return res;
    }
}

