/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.rcollections.BMap;
import io.aether.utils.rcollections.BMapImpl;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RMap;
import io.aether.utils.rcollections.RQueue;
import io.aether.utils.rcollections.RSet;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RCol {
    public static <T> RQueue<T> of(Queue<T> src) {
        return RQueue.of(src);
    }

    public static <T> RSet<T> of(Set<T> src) {
        return RSet.of(src);
    }

    public static <T> RCollection<T> of(Collection<T> src) {
        return RCollection.of(src);
    }

    public static <K, V> RMap<K, V> of(Map<K, V> src) {
        return RMap.of(src);
    }

    public static <K, V> RMap<K, V> map() {
        return RCol.of(new ConcurrentHashMap());
    }

    public static <T> RSet<T> set() {
        return RCol.of(new ConcurrentHashSet());
    }

    public static <T> RQueue<T> queue() {
        return RCol.of(new ConcurrentLinkedQueue());
    }

    public static <K, V> BMap<K, V> bMap(long timeoutMs, String name) {
        return new BMapImpl(10, name, timeoutMs);
    }

    public static <K, V> BMap<K, V> bMap() {
        return RCol.bMap(4000L, "GenericBMap");
    }
}

