/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.rcollections;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.rcollections.RCollection;
import io.aether.utils.rcollections.RQueueBySrc;
import io.aether.utils.slots.EventConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public interface RQueue<T>
extends RCollection<T>,
Queue<T> {
    @Override
    default public boolean retainAll(@NotNull Collection<?> c) {
        return RCollection.super.retainAll(c);
    }

    @Override
    default public void clear() {
        RCollection.super.clear();
    }

    @Override
    default public boolean addAll(@NotNull Collection<? extends T> c) {
        return RCollection.super.addAll(c);
    }

    @Override
    default public boolean containsAll(@NotNull Collection<?> c) {
        return RCollection.super.containsAll(c);
    }

    @Override
    default public boolean removeAll(@NotNull Collection<?> c) {
        return RCollection.super.removeAll(c);
    }

    default public <T2> void link(RQueue<T2> other, AFunction<T, T2> f, AFunction<T2, T> back) {
        this.forAdd().add(v -> other.add(f.apply(v)));
        this.forRemove().add(v -> other.remove(f.apply(v)));
        other.forAdd().add(v -> this.add(back.apply(v)));
        other.forRemove().add(v -> this.remove(back.apply(v)));
        for (Object e : other) {
            this.add(back.apply(e));
        }
        for (Object e : this) {
            other.add(f.apply(e));
        }
    }

    @Override
    @NotNull
    default public <T2> RQueue<T2> map(final AFunction<T, T2> f, final AFunction<T2, T> back) {
        final RQueue self = this;
        return new RQueue<T2>(){
            final EventConsumer<T2> forAdd = new EventConsumer();
            final EventConsumer<T2> forRemove = new EventConsumer();

            @Override
            public void toString(AString sb) {
                sb.add("queue ").add(this.size()).add(" (");
                boolean first = true;
                for (Object e : this) {
                    if (first) {
                        first = false;
                    } else {
                        sb.add(", ");
                    }
                    sb.add(e);
                }
                sb.add(")");
            }

            public String toString() {
                return this.toString2();
            }

            @Override
            public boolean offer(T2 t2) {
                return self.offer(back.apply(t2));
            }

            @Override
            public T2 remove() {
                return f.apply(self.remove());
            }

            @Override
            public T2 poll() {
                Object v = self.poll();
                if (v == null) {
                    return null;
                }
                return f.apply(v);
            }

            @Override
            public T2 element() {
                return f.apply(self.element());
            }

            @Override
            public T2 peek() {
                return f.apply(self.peek());
            }

            @Override
            public EventConsumer<T2> forAdd() {
                return this.forAdd;
            }

            @Override
            public EventConsumer<T2> forRemove() {
                return this.forRemove;
            }

            @Override
            public int size() {
                return self.size();
            }

            @Override
            public boolean isEmpty() {
                return self.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return self.contains(back.apply(RU.cast(o)));
            }

            @Override
            @NotNull
            public Iterator<T2> iterator() {
                final Iterator it = self.iterator();
                return new Iterator<T2>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T2 next() {
                        return f.apply(it.next());
                    }
                };
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return Flow.flow(self).map(f).toArray();
            }

            @Override
            @NotNull
            public <T5> @NotNull T5 @NotNull [] toArray(@NotNull @NotNull T5 @NotNull [] a) {
                return Flow.flow(self).map(f).toList().toArray(a);
            }

            @Override
            public boolean add(T2 t2) {
                return self.add(back.apply(t2));
            }

            @Override
            public boolean remove(Object o) {
                return self.remove(back.apply(RU.cast(o)));
            }
        };
    }

    public static <E> RQueue<E> of(Queue<E> src) {
        if (src instanceof RQueue) {
            return (RQueue)RU.cast(src);
        }
        return new RQueueBySrc<E>(src);
    }
}

